/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class IllagerTeleportPacket {
    private int entityId;

    public IllagerTeleportPacket(int entityIdIn) {
        this.entityId = entityIdIn;
    }

    public static void encoder(IllagerTeleportPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.entityId);
    }

    public static IllagerTeleportPacket decoder(FriendlyByteBuf buff) {
        return new IllagerTeleportPacket(buff.readInt());
    }

    public static void handler(IllagerTeleportPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> IllagerTeleportPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(IllagerTeleportPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
        if (entity instanceof SkiesIllagerBossEntity) {
            SkiesIllagerBossEntity illager = (SkiesIllagerBossEntity)entity;
            illager.noLerp = true;
        }
    }
}

