/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei.category;

import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

abstract class SkiesCategory<T>
implements IRecipeCategory<T> {
    protected final IDrawableStatic background;
    protected final IDrawable icon;

    public SkiesCategory(IGuiHelper guiHelper, ItemLike icon, ResourceLocation texture, int width, int height) {
        this.background = guiHelper.drawableBuilder(texture, 0, 0, width, height).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(icon));
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.blue_skies.jei." + this.getRecipeType().getUid().m_135815_()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected IRecipeSlotBuilder input(IRecipeLayoutBuilder layout, int x, int y) {
        return layout.addSlot(RecipeIngredientRole.INPUT, x, y);
    }

    protected IRecipeSlotBuilder inputStack(IRecipeLayoutBuilder layout, int x, int y, Collection<ItemStack> items) {
        return (IRecipeSlotBuilder)this.input(layout, x, y).addItemStacks(List.copyOf(items));
    }

    protected IRecipeSlotBuilder input(IRecipeLayoutBuilder layout, int x, int y, ItemStack ... items) {
        return this.inputStack(layout, x, y, List.of(items));
    }

    protected IRecipeSlotBuilder input(IRecipeLayoutBuilder layout, int x, int y, Collection<Item> items) {
        return this.inputStack(layout, x, y, items.stream().map(ItemStack::new).toList());
    }

    protected IRecipeSlotBuilder input(IRecipeLayoutBuilder layout, int x, int y, Item ... items) {
        return this.input(layout, x, y, List.of(items));
    }

    protected IRecipeSlotBuilder output(IRecipeLayoutBuilder layout, int x, int y) {
        return layout.addSlot(RecipeIngredientRole.OUTPUT, x, y);
    }

    protected IRecipeSlotBuilder outputStack(IRecipeLayoutBuilder layout, int x, int y, Collection<ItemStack> items) {
        return (IRecipeSlotBuilder)this.output(layout, x, y).addItemStacks(List.copyOf(items));
    }

    protected IRecipeSlotBuilder output(IRecipeLayoutBuilder layout, int x, int y, ItemStack ... items) {
        return this.outputStack(layout, x, y, List.of(items));
    }

    protected IRecipeSlotBuilder output(IRecipeLayoutBuilder layout, int x, int y, Collection<Item> items) {
        return this.outputStack(layout, x, y, items.stream().map(ItemStack::new).toList());
    }

    protected IRecipeSlotBuilder output(IRecipeLayoutBuilder layout, int x, int y, Item ... items) {
        return this.output(layout, x, y, List.of(items));
    }
}

