/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.IToJson;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public abstract class SkiesDataProvider<D extends IToJson<D>>
implements DataProvider {
    protected static final Logger LOGGER = BlueSkies.makeLogger(SkiesDataProvider.class);
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected Map<ResourceLocation, D> data;
    protected final DataGenerator generator;
    protected final String name;

    public SkiesDataProvider(DataGenerator generator, String name) {
        this.generator = generator;
        this.name = "blue_skies/" + name;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.data = this.gatherData();
        Path outputFolder = this.generator.getPackOutput().m_245114_();
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        for (Map.Entry<ResourceLocation, D> dataEntry : this.data.entrySet()) {
            Path outputFile = this.createPath(outputFolder, dataEntry.getKey());
            try {
                JsonObject json = ((IToJson)dataEntry.getValue()).toJson();
                list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)outputFile));
            }
            catch (Exception e) {
                LOGGER.error("Couldn't save {} {}", (Object)this.name, (Object)outputFile, (Object)e);
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected abstract Map<ResourceLocation, D> gatherData();

    protected Path createPath(Path outputFolder, ResourceLocation dataEntryName) {
        return outputFolder.resolve("data/" + dataEntryName.m_135827_() + "/" + this.name + "/" + dataEntryName.m_135815_() + ".json");
    }

    public String m_6055_() {
        return this.name;
    }
}

