/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient.storage;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageHandler;

public class DefaultIngredientComponentStorageHandler
implements IIngredientComponentStorageHandler {
    private final Map<IngredientComponent<?, ?>, IIngredientComponentStorage<?, ?>> storages = Maps.newIdentityHashMap();

    @Override
    public Collection<IngredientComponent<?, ?>> getComponents() {
        return this.storages.keySet();
    }

    @Override
    @Nullable
    public <T, M> IIngredientComponentStorage<T, M> getStorage(IngredientComponent<T, M> ingredientComponent) {
        return this.storages.get(ingredientComponent);
    }

    public <T, M> void setStorage(IngredientComponent<T, M> ingredientComponent, @Nullable IIngredientComponentStorage<T, M> storage) {
        if (storage == null) {
            this.storages.remove(ingredientComponent);
        } else {
            this.storages.put(ingredientComponent, storage);
        }
    }
}

