/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.FilteredItemHandlerItemStackIterator;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemHandlerItemStackIterator;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public class DefaultSlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    private final IItemHandler itemHandler;

    public DefaultSlotlessItemHandlerWrapper(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public Iterator<ItemStack> getItems() {
        return new ItemHandlerItemStackIterator(this.getItemHandler());
    }

    @Override
    public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
        return new FilteredItemHandlerItemStackIterator(this.getItemHandler(), stack, matchFlags);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.getItemHandler().getSlots(); ++i) {
            stack = this.getItemHandler().insertItem(i, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, boolean simulate) {
        IItemHandler itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.extractItem(i, amount, simulate);
            if (itemStack.m_41619_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        IItemHandler itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack;
            ItemStack tempItemStack;
            int amount = matchStack.m_41613_();
            if (!simulate && ((tempItemStack = itemHandler.extractItem(i, amount, true)).m_41619_() || !ItemMatch.areItemStacksEqual(matchStack, tempItemStack, matchFlags)) || (itemStack = itemHandler.extractItem(i, amount, simulate)).m_41619_() || !ItemMatch.areItemStacksEqual(matchStack, itemStack, matchFlags)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getLimit() {
        IItemHandler itemHandler = this.getItemHandler();
        int total = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            total += itemHandler.getSlotLimit(i);
        }
        return total;
    }
}

