/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import reliquary.item.ToggleableItem;
import reliquary.item.util.FilteredItemHandlerProvider;
import reliquary.item.util.FilteredItemStack;
import reliquary.item.util.FilteredItemStackHandler;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Settings;
import reliquary.util.LogHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class RendingGaleItem
extends ToggleableItem
implements IScrollableItem {
    private static final String COUNT_TAG = "count";
    private static final int NO_DAMAGE_ELYTRA_TICKS = 3;
    private static final Field TICKS_ELYTRA_FLYING = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"f_20937_");

    public RendingGaleItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rendingGale, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", this.getFeatherCount(rendingGale, true) / 100);
        tooltipBuilder.description(this, ".tooltip.controls", new Object[0]);
        if (this.isEnabled(rendingGale)) {
            tooltipBuilder.absorbActive(Items.f_42402_.m_7626_(new ItemStack((ItemLike)Items.f_42402_)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private static int getChargeLimit() {
        return (Integer)Settings.COMMON.items.rendingGale.chargeLimit.get();
    }

    public static int getChargeCost() {
        return (Integer)Settings.COMMON.items.rendingGale.castChargeCost.get();
    }

    private static int getFeathersWorth() {
        return (Integer)Settings.COMMON.items.rendingGale.chargeFeatherWorth.get();
    }

    private static int getBoltChargeCost() {
        return (Integer)Settings.COMMON.items.rendingGale.boltChargeCost.get();
    }

    private static int getBoltTargetRange() {
        return (Integer)Settings.COMMON.items.rendingGale.blockTargetRange.get();
    }

    private static int getRadialPushRadius() {
        return (Integer)Settings.COMMON.items.rendingGale.pushPullRadius.get();
    }

    private void attemptFlight(LivingEntity entityLiving) {
        double distance;
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        BlockHitResult rayTrace = RendingGaleItem.m_41435_((Level)player.m_9236_(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        Vec3 motion = player.m_20154_().m_82542_(2.0, 2.0, 2.0);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (distance = player.m_20183_().m_123331_((Vec3i)rayTrace.m_82425_())) < 40.0) {
            double slowDownFactor = distance / 40.0;
            motion = player.m_20154_().m_82542_(slowDownFactor, slowDownFactor, slowDownFactor);
        }
        player.m_20256_(motion);
        player.f_19789_ = 0.0f;
        if (player.m_21255_()) {
            RendingGaleItem.preventElytraDamage(player);
        }
    }

    private static void preventElytraDamage(Player player) {
        try {
            TICKS_ELYTRA_FLYING.set(player, 3);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error setting ticksElytraFlying on player ", e);
        }
    }

    public void m_6883_(ItemStack rendingGale, Level world, Entity entity, int slotNumber, boolean isSelected) {
        Player player;
        block5: {
            block4: {
                if (world.f_46443_ || !(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (world.m_46467_() % 10L == 0L) break block5;
            }
            return;
        }
        if (this.isEnabled(rendingGale)) {
            int currentFeatherCharge = this.getFeatherCount(rendingGale);
            this.consumeAndCharge(player, RendingGaleItem.getChargeLimit() - currentFeatherCharge, RendingGaleItem.getFeathersWorth(), Items.f_42402_, 16, (int chargeToAdd) -> this.setFeatherCount(rendingGale, currentFeatherCharge + chargeToAdd, !player.m_6117_()));
        }
    }

    public Mode getMode(ItemStack stack) {
        return NBTHelper.getEnumConstant(stack, "mode", Mode::valueOf).orElse(Mode.FLIGHT);
    }

    private void setMode(ItemStack stack, Mode mode) {
        NBTHelper.putString("mode", stack, mode.m_7912_());
    }

    private void cycleMode(ItemStack stack, boolean isRaining, boolean next) {
        Mode modeToSet;
        Mode currentMode = this.getMode(stack);
        Mode mode = modeToSet = next ? currentMode.next() : currentMode.previous();
        if (!isRaining && modeToSet == Mode.BOLT) {
            modeToSet = next ? modeToSet.next() : modeToSet.previous();
        }
        this.setMode(stack, modeToSet);
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, player.m_9236_().m_46471_(), scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ArrayList<FilteredItemStack> filteredStacks = new ArrayList<FilteredItemStack>();
        filteredStacks.add(new FilteredItemStack(Items.f_42402_, (int)((Integer)Settings.COMMON.items.rendingGale.chargeLimit.get()), (int)((Integer)Settings.COMMON.items.rendingGale.chargeFeatherWorth.get()), false));
        return new FilteredItemHandlerProvider(filteredStacks);
    }

    public int m_8105_(ItemStack par1ItemStack) {
        return 6000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack rendingGale = player.m_21120_(hand);
        if (player.m_6144_()) {
            super.m_7203_(world, player, hand);
        } else {
            player.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)rendingGale);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack rendingGale, int remainingUseDuration) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.getFeatherCount(rendingGale, player.m_9236_().f_46443_) <= 0) {
            player.m_21253_();
            return;
        }
        if (this.getMode(rendingGale) == Mode.BOLT) {
            if (remainingUseDuration % 8 == 0) {
                this.spawnBolt(rendingGale, player);
            }
        } else {
            if (this.getMode(rendingGale) == Mode.FLIGHT) {
                this.attemptFlight((LivingEntity)player);
                this.spawnFlightParticles(player.m_9236_(), player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), player);
            } else if (this.getMode(rendingGale) == Mode.PUSH) {
                this.doRadialPush(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), player, false);
            } else if (this.getMode(rendingGale) == Mode.PULL) {
                this.doRadialPush(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), player, true);
            }
            if (!player.m_9236_().f_46443_) {
                this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - RendingGaleItem.getChargeCost()), false);
            }
        }
    }

    private void spawnBolt(ItemStack rendingGale, Player player) {
        HitResult rayTraceResult = player.m_19907_((double)RendingGaleItem.getBoltTargetRange(), 1.0f, true);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            LightningBolt bolt;
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
            BlockPos pos = blockRayTraceResult.m_82425_();
            int attemptedY = pos.m_123342_();
            if (!player.m_9236_().m_46758_(pos)) {
                ++attemptedY;
            }
            if (!player.m_9236_().f_46443_ && player.m_9236_().m_46758_(new BlockPos(pos.m_123341_(), attemptedY, pos.m_123343_())) && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_())) != null) {
                bolt.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                player.m_9236_().m_7967_((Entity)bolt);
                this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - RendingGaleItem.getBoltChargeCost()), false);
            }
        }
    }

    public void m_5551_(ItemStack rendingGale, Level world, LivingEntity entityLiving, int timeLeft) {
        if (world.f_46443_) {
            return;
        }
        NBTHelper.putInt(COUNT_TAG, rendingGale, this.getFeatherCount(rendingGale));
    }

    public boolean hasFlightCharge(ItemStack stack) {
        return this.getFeatherCount(stack) > 0;
    }

    public int getFeatherCount(ItemStack rendingGale) {
        return this.getFeatherCount(rendingGale, false);
    }

    private int getFeatherCount(ItemStack rendingGale, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInt(COUNT_TAG, rendingGale);
        }
        return rendingGale.getCapability(ForgeCapabilities.ITEM_HANDLER, null).filter(FilteredItemStackHandler.class::isInstance).map(handler -> ((FilteredItemStackHandler)handler).getTotalAmount(0)).orElse(0);
    }

    public void setFeatherCount(ItemStack stack, int featherCount, boolean updateNBT) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).filter(FilteredItemStackHandler.class::isInstance).ifPresent(handler -> {
            ((FilteredItemStackHandler)handler).setTotalCount(0, featherCount);
            if (updateNBT) {
                NBTHelper.putInt(COUNT_TAG, stack, featherCount);
            }
        });
    }

    public void doRadialPush(Level world, double posX, double posY, double posZ, @Nullable Player player, boolean pull) {
        this.spawnRadialHurricaneParticles(world, posX, posY, posZ, player, pull);
        if (world.f_46443_) {
            return;
        }
        double lowerX = posX - (double)RendingGaleItem.getRadialPushRadius();
        double lowerY = posY - (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double lowerZ = posZ - (double)RendingGaleItem.getRadialPushRadius();
        double upperX = posX + (double)RendingGaleItem.getRadialPushRadius();
        double upperY = posY + (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double upperZ = posZ + (double)RendingGaleItem.getRadialPushRadius();
        List entities = world.m_6443_(Entity.class, new AABB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ), e -> e instanceof Mob || e instanceof Projectile);
        for (Entity entity : entities) {
            double distance = this.getDistanceToEntity(posX, posY, posZ, entity);
            if (!(distance < (double)RendingGaleItem.getRadialPushRadius()) || this.isBlacklistedEntity(entity) || entity.equals((Object)player)) continue;
            Vec3 pushVector = pull ? new Vec3(posX - entity.m_20185_(), posY - entity.m_20186_(), posZ - entity.m_20189_()) : new Vec3(entity.m_20185_() - posX, entity.m_20186_() - posY, entity.m_20189_() - posZ);
            pushVector = pushVector.m_82541_();
            entity.m_6478_(MoverType.PLAYER, new Vec3(0.0, 0.2, 0.0));
            entity.m_6478_(MoverType.PLAYER, new Vec3(pushVector.f_82479_, Math.min(pushVector.f_82480_, 0.1) * 1.5, pushVector.f_82481_));
        }
    }

    private boolean isBlacklistedEntity(Entity entity) {
        String entityName = RegistryHelper.getRegistryName(entity).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Settings.COMMON.items.rendingGale.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof Projectile && ((List)Settings.COMMON.items.rendingGale.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof Mob && ((List)Settings.COMMON.items.rendingGale.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    private float getDistanceToEntity(double posX, double posY, double posZ, Entity entityIn) {
        float f = (float)(posX - entityIn.m_20185_());
        float f1 = (float)(posY - entityIn.m_20186_());
        float f2 = (float)(posZ - entityIn.m_20189_());
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    private void spawnFlightParticles(Level level, double x, double y, double z, Player player) {
        Vec3 lookVector = player.m_20154_();
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_());
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (level.f_46441_.m_188501_() - 0.5f);
            float randY = 10.0f * (level.f_46441_.m_188501_() - 0.5f);
            float randZ = 10.0f * (level.f_46441_.m_188501_() - 0.5f);
            level.m_7106_((ParticleOptions)blockParticleData, x + (double)randX + lookVector.f_82479_ * 20.0, y + (double)randY + lookVector.f_82480_ * 20.0, z + (double)randZ + lookVector.f_82481_ * 20.0, -lookVector.f_82479_ * 5.0, -lookVector.f_82480_ * 5.0, -lookVector.f_82481_ * 5.0);
        }
    }

    private void spawnRadialHurricaneParticles(Level world, double posX, double posY, double posZ, @Nullable Player player, boolean pull) {
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_());
        for (int i = 0; i < 3; ++i) {
            float randX = world.f_46441_.m_188501_() - 0.5f;
            float randZ = world.f_46441_.m_188501_() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            double posYAdjusted = player == null ? posY : posY + (double)player.m_20192_() - (double)(player.m_20206_() / 2.0f);
            world.m_7106_((ParticleOptions)blockParticleData, posX + (double)randX, posYAdjusted, posZ + (double)randZ, (double)motX, 0.0, (double)motZ);
        }
    }

    public int getFeatherCountClient(ItemStack rendingGale, Player player) {
        int featherCount = this.getFeatherCount(rendingGale, true);
        Mode mode = this.getMode(rendingGale);
        int ticksInUse = this.m_8105_(rendingGale) - player.m_21212_();
        if (player.m_6117_()) {
            featherCount = Math.max(0, featherCount - (mode == Mode.BOLT ? RendingGaleItem.getBoltChargeCost() * (ticksInUse / 8) : RendingGaleItem.getChargeCost() * ticksInUse));
        }
        return featherCount;
    }

    public static enum Mode implements StringRepresentable
    {
        FLIGHT,
        PUSH,
        PULL,
        BOLT;

        private static final Mode[] VALUES;

        public String m_7912_() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

