/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import reliquary.init.ModEnchantments;
import reliquary.init.ModItems;

public class RandomChanceLootingSeveringCondition
implements LootItemCondition {
    final float percent;
    final float lootingMultiplier;
    private final float severingMultiplier;

    RandomChanceLootingSeveringCondition(float percent, float lootingMultiplier, float severingMultiplier) {
        this.percent = percent;
        this.lootingMultiplier = lootingMultiplier;
        this.severingMultiplier = severingMultiplier;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModItems.RANDOM_CHANCE_LOOTING_SEVERING.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81458_);
    }

    public boolean test(LootContext lootContext) {
        int i = lootContext.getLootingModifier();
        return lootContext.m_230907_().m_188501_() < this.percent + (float)i * this.lootingMultiplier + (float)this.getSeveringModifier(lootContext) * this.severingMultiplier;
    }

    private int getSeveringModifier(LootContext lootContext) {
        Entity killer = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (!(killer instanceof LivingEntity)) {
            return 0;
        }
        LivingEntity livingEntity = (LivingEntity)killer;
        Enchantment severingEnchantment = (Enchantment)ModEnchantments.SEVERING.get();
        Collection iterable = severingEnchantment.m_44684_(livingEntity).values();
        int severingLevel = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.m_44843_((Enchantment)severingEnchantment, (ItemStack)itemstack);
            if (itemstack.m_41720_() == ModItems.MAGICBANE.get()) {
                j += 2;
            }
            if (j <= severingLevel) continue;
            severingLevel = j;
        }
        return severingLevel;
    }

    public static LootItemCondition.Builder randomChanceLootingSevering(float percent, float lootingMultiplier, float severingMultiplier) {
        return () -> new RandomChanceLootingSeveringCondition(percent, lootingMultiplier, severingMultiplier);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<RandomChanceLootingSeveringCondition> {
        public void serialize(JsonObject jsonObject, RandomChanceLootingSeveringCondition condition, JsonSerializationContext context) {
            jsonObject.addProperty("chance", (Number)Float.valueOf(condition.percent));
            jsonObject.addProperty("looting_multiplier", (Number)Float.valueOf(condition.lootingMultiplier));
            jsonObject.addProperty("severing_multiplier", (Number)Float.valueOf(condition.severingMultiplier));
        }

        public RandomChanceLootingSeveringCondition deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            return new RandomChanceLootingSeveringCondition(GsonHelper.m_13915_((JsonObject)jsonObject, (String)"chance"), GsonHelper.m_13915_((JsonObject)jsonObject, (String)"looting_multiplier"), GsonHelper.m_13915_((JsonObject)jsonObject, (String)"severing_multiplier"));
        }
    }
}

