/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.soil;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.recipes.soil.BasicSoil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicSoilSerializer
implements RecipeSerializer<BasicSoil> {
    public static BasicSoilSerializer SERIALIZER = new BasicSoilSerializer();

    public BasicSoil fromJson(ResourceLocation id, JsonObject json) {
        if (id.m_135827_().equalsIgnoreCase("farmersdelight")) {
            Constants.LOG.warn("Soil {} has been disabled by the BotanyPot devs to improve compatibility.", (Object)id);
            return null;
        }
        Ingredient input = (Ingredient)Serializers.INGREDIENT.fromJSON(json, "input");
        DisplayState renderState = (DisplayState)DisplayState.SERIALIZER.fromJSON(json, "display");
        float growthModifier = ((Float)Serializers.FLOAT.fromJSON(json, "growthModifier", (Object)Float.valueOf(1.0f))).floatValue();
        Set categories = Serializers.STRING.fromJSONSet(json, "categories");
        int lightLevel = (Integer)Serializers.INT.fromJSON(json, "lightLevel", (Object)0);
        if (growthModifier <= -1.0f) {
            throw new JsonParseException("Soil " + id + " has an invalid growth modifier. It must be greater than -1. Growth modifier was " + growthModifier);
        }
        if (lightLevel > 15 || lightLevel < 0) {
            throw new JsonParseException("Soil " + id + " has an invalid light level. Light levels must be between 0 and 15. Light level was " + lightLevel);
        }
        return new BasicSoil(id, input, renderState, growthModifier, categories, lightLevel);
    }

    public BasicSoil fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)Serializers.INGREDIENT.fromByteBuf(buffer);
        DisplayState renderState = (DisplayState)DisplayState.SERIALIZER.fromByteBuf(buffer);
        float growthModifier = ((Float)Serializers.FLOAT.fromByteBuf(buffer)).floatValue();
        HashSet<String> categories = new HashSet<String>(Serializers.STRING.fromByteBufList(buffer));
        int lightLevel = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicSoil(id, ingredient, renderState, growthModifier, categories, lightLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicSoil soilInfo) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)soilInfo.ingredient);
        DisplayState.SERIALIZER.toByteBuf(buffer, (Object)soilInfo.displayState);
        Serializers.FLOAT.toByteBuf(buffer, (Object)Float.valueOf(soilInfo.growthModifier));
        Serializers.STRING.toByteBufList(buffer, new ArrayList<String>(soilInfo.categories));
        Serializers.INT.toByteBuf(buffer, (Object)soilInfo.lightLevel);
    }
}

