/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.forge.client.events;

import io.github.flemmli97.tenshilib.client.AnimationManager;
import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.network.C2SPacketHit;
import io.github.flemmli97.tenshilib.forge.network.PacketHandler;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderLivingEvent;

public class ClientEvents {
    public static void reloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)AnimationManager.getInstance());
        event.registerReloadListener((PreparableReloadListener)CustomRiderRendererManager.getInstance());
    }

    public static void clickSpecial(InputEvent.InteractionKeyMappingTriggered event) {
        boolean canceled;
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND && (canceled = ClientHandlers.emptyClick(aoe -> PacketHandler.sendToServer(new C2SPacketHit(aoe != false ? C2SPacketHit.HitType.AOE : C2SPacketHit.HitType.EXT))))) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        for (SpawnEgg egg : SpawnEgg.getEggs()) {
            event.register(egg::getColor, new ItemLike[]{egg});
        }
    }

    public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
        if (ClientHandlers.shouldDisableRender((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }
}

