/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.blockentity.spatial.SpatialIOPortBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public final class SpatialTestPlots {
    private SpatialTestPlots() {
    }

    @TestPlot(value="controller_inside_scs")
    public static void controllerInsideScs(PlotBuilder plot) {
        plot.creativeEnergyCell("0 0 0");
        plot.block("[1,10] 0 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 [1,10] 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 0 [1,10]", AEBlocks.SPATIAL_PYLON);
        plot.blockEntity("-1 0 0", AEBlocks.SPATIAL_IO_PORT, port -> port.getInternalInventory().insertItem(0, AEItems.SPATIAL_CELL128.stack(), false));
        BlockPos leverPos = plot.leverOn(new BlockPos(-1, 0, 0), Direction.WEST);
        plot.creativeEnergyCell("[4,6] 3 [4,6]");
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    boolean edge;
                    boolean bl = edge = Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2;
                    if (!edge) continue;
                    plot.block(new BlockPos(5 + x, 5 + y, 5 + z), AEBlocks.CONTROLLER);
                }
            }
        }
        plot.test(helper -> helper.m_177425_().m_177544_(5).m_177562_(() -> helper.m_177421_(leverPos)).m_177544_(5).m_177543_());
    }

    @TestPlot(value="crafting_cpu_inside_scs")
    public static void craftingCpuInsideScs(PlotBuilder plot) {
        plot.creativeEnergyCell("0 0 0");
        plot.block("[1,10] 0 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 [1,10] 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 0 [1,10]", AEBlocks.SPATIAL_PYLON);
        plot.blockEntity("-1 0 0", AEBlocks.SPATIAL_IO_PORT, port -> port.getInternalInventory().insertItem(0, AEItems.SPATIAL_CELL128.stack(), false));
        BlockPos leverPos = plot.leverOn(new BlockPos(-1, 0, 0), Direction.WEST);
        plot.creativeEnergyCell("3 0 3");
        plot.block("[2,4] [1,3] [2,4]", AEBlocks.CRAFTING_STORAGE_64K);
        plot.test(helper -> helper.m_177425_().m_177544_(5).m_177562_(() -> helper.m_177421_(leverPos)).m_177544_(5).m_177543_());
    }

    @TestPlot(value="spatial_entity_storage")
    public static void storeAndRetrieveEntities(PlotBuilder plot) {
        BlockPos chickenPos = new BlockPos(1, 1, 1);
        BlockPos ioPortPos = new BlockPos(-1, 0, 0);
        plot.creativeEnergyCell("0 0 0");
        plot.block("[1,2] 0 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 [1,2] 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 0 [1,2]", AEBlocks.SPATIAL_PYLON);
        plot.block(chickenPos.m_7495_(), Blocks.f_50069_);
        plot.block(chickenPos.m_7494_(), Blocks.f_50069_);
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            plot.block(chickenPos.m_121945_(dir), Blocks.f_50058_);
            plot.block(chickenPos.m_121945_(dir).m_7494_(), Blocks.f_50058_);
        }
        plot.blockEntity(ioPortPos, AEBlocks.SPATIAL_IO_PORT, port -> port.getInternalInventory().insertItem(0, AEItems.SPATIAL_CELL2.stack(), false));
        BlockPos buttonPos = plot.buttonOn(ioPortPos, Direction.WEST);
        plot.test(helper -> helper.m_177425_().m_177562_(() -> {
            helper.m_177301_();
            helper.m_177176_(EntityType.f_20555_, chickenPos.m_7494_());
            helper.m_177189_(Items.f_41999_, (float)chickenPos.m_123341_() + 0.5f, (float)chickenPos.m_123342_() + 0.5f, (float)chickenPos.m_123343_() + 0.5f);
        }).m_177544_(5).m_177562_(() -> helper.m_177385_(buttonPos)).m_177544_(5).m_177562_(() -> {
            helper.m_177198_(Items.f_41999_, chickenPos, 1.0, 0);
            helper.m_239371_(EntityType.f_20555_, chickenPos, 0, 1.0);
            ItemStack cell = SpatialTestPlots.getCellFromSpatialIoPortOutput(helper, ioPortPos);
            SpatialTestPlots.insertCell(helper, ioPortPos, cell);
        }).m_177544_(25).m_177562_(() -> helper.m_177385_(buttonPos)).m_177544_(5).m_177562_(() -> {
            helper.m_177198_(Items.f_41999_, chickenPos, 1.0, 1);
            helper.m_239371_(EntityType.f_20555_, chickenPos, 1, 1.0);
        }).m_177543_());
    }

    private static ItemStack getCellFromSpatialIoPortOutput(PlotTestHelper helper, BlockPos ioPortPos) {
        SpatialIOPortBlockEntity spatialIoPort = (SpatialIOPortBlockEntity)helper.m_177347_(ioPortPos);
        ItemStack cell = spatialIoPort.getInternalInventory().extractItem(1, 1, false);
        helper.check(AEItems.SPATIAL_CELL2.isSameAs(cell), "no spatial cell in output slot", ioPortPos);
        return cell;
    }

    private static void insertCell(PlotTestHelper helper, BlockPos ioPortPos, ItemStack cell) {
        SpatialIOPortBlockEntity spatialIoPort = (SpatialIOPortBlockEntity)helper.m_177347_(ioPortPos);
        spatialIoPort.getInternalInventory().insertItem(0, cell, false);
    }

    private static PlotInfo getPlotInfo(PlotTestHelper helper, BlockPos ioPortPos, ItemStack cell) {
        helper.check(cell.m_41720_() instanceof ISpatialStorageCell, "cell is not a spatial cell", ioPortPos);
        ISpatialStorageCell spatialCell = (ISpatialStorageCell)cell.m_41720_();
        int plotId = spatialCell.getAllocatedPlotId(cell);
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        helper.check(plot != null, "plot not found", ioPortPos);
        return new PlotInfo(SpatialStoragePlotManager.INSTANCE.getLevel(), new AABB(plot.getOrigin(), plot.getOrigin().m_121955_((Vec3i)plot.getSize())), plot.getOrigin());
    }

    record PlotInfo(ServerLevel level, AABB bounds, BlockPos origin) {
    }
}

