/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ParallelGearboxScenes {
    public static void parallelGearbox(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("parallel_gearbox", "Relaying rotational force using Parallel Gearboxes");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.world().showSection(util.select().fromTo(4, 1, 6, 3, 2, 5), Direction.UP);
        scene.idle(10);
        BlockPos cogBack = util.grid().at(3, 2, 4);
        BlockPos cogLeft = util.grid().at(4, 2, 3);
        BlockPos cogFront = util.grid().at(3, 2, 2);
        BlockPos cogRight = util.grid().at(2, 2, 3);
        BlockPos cogTop = util.grid().at(3, 3, 3);
        scene.world().showSection(util.select().position(cogBack), Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(cogLeft), Direction.WEST);
        scene.world().showSection(util.select().position(cogLeft.m_122029_()), Direction.WEST);
        scene.world().showSection(util.select().position(cogRight), Direction.EAST);
        scene.world().showSection(util.select().position(cogRight.m_122024_()), Direction.EAST);
        scene.idle(5);
        scene.world().showSection(util.select().position(cogFront), Direction.SOUTH);
        scene.world().showSection(util.select().position(cogFront.m_122012_()), Direction.SOUTH);
        scene.idle(5);
        ElementLink topMovableCog = scene.world().showIndependentSection(util.select().position(cogTop), Direction.DOWN);
        scene.world().moveSection(topMovableCog, util.vector().of(0.0, -0.5, 0.0), 5);
        scene.idle(10);
        scene.overlay().showText(80).colored(PonderPalette.RED).pointAt(util.vector().blockSurface(cogRight.m_122024_(), Direction.WEST)).placeNearTarget().text("This setup is simple but currently impossible");
        scene.idle(80);
        Selection gearbox = util.select().position(3, 2, 3);
        scene.world().hideSection(util.select().fromTo(4, 2, 2, 2, 2, 4).substract(gearbox), Direction.UP);
        scene.world().hideIndependentSection(topMovableCog, Direction.UP);
        scene.idle(20);
        BlockState defaultState = AllBlocks.SHAFT.getDefaultState();
        BlockState cogState = AllBlocks.COGWHEEL.getDefaultState();
        scene.world().setBlock(cogBack, (BlockState)defaultState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Z), false);
        scene.world().setBlock(cogFront, (BlockState)defaultState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Z), false);
        scene.world().setBlock(cogRight, (BlockState)defaultState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.X), false);
        scene.world().setBlock(cogLeft, (BlockState)defaultState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.X), false);
        scene.world().showSection(util.select().fromTo(4, 2, 2, 2, 2, 4), Direction.DOWN);
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.GREEN).pointAt(util.vector().topOf(3, 2, 3)).placeNearTarget().attachKeyFrame().text("A parallel gearbox encapsulates this into a block");
        scene.idle(90);
        scene.world().setBlock(cogFront.m_122012_(), (BlockState)cogState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Z), true);
        scene.world().setBlock(cogRight.m_122024_(), (BlockState)cogState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.X), true);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(cogFront.m_122012_());
        scene.effects().rotationDirectionIndicator(cogRight.m_122024_());
        scene.idle(15);
        scene.overlay().showText(60).pointAt(util.vector().of(3.0, 2.5, 3.0)).placeNearTarget().text("Shafts around corners rotate in the same direction");
        scene.idle(70);
        scene.world().hideSection(util.select().fromTo(1, 2, 3, 2, 2, 3), Direction.WEST);
        scene.world().hideSection(util.select().fromTo(4, 2, 3, 5, 2, 3), Direction.EAST);
        scene.world().setBlock(cogBack.m_122019_(), (BlockState)cogState.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Z), true);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(cogFront.m_122012_());
        scene.effects().rotationDirectionIndicator(cogBack.m_122019_());
        scene.idle(15);
        scene.overlay().showText(60).pointAt(util.vector().centerOf(3, 2, 5)).placeNearTarget().text("Straight connections will be reversed");
        scene.idle(80);
        scene.markAsFinished();
    }
}

