/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.util.rope;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.core.block.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.core.util.rope.IncompleteRopeConnection;
import net.satisfy.brewery.core.util.rope.RopeConnection;

public class RopeHelper {
    public static final int HANGING_AMOUNT = 1;
    public static final ObjectList<IncompleteRopeConnection> incompleteRopes = new ObjectArrayList(256);

    public static void tick() {
        incompleteRopes.removeIf(IncompleteRopeConnection::tryCompleteOrRemove);
    }

    public static void createConnection(Minecraft client, int fromId, int toId) {
        RopeHelper.createConnections(client, fromId, new int[]{toId});
    }

    public static void createConnections(Minecraft client, int fromId, int[] toIds) {
        if (client.f_91073_ == null) {
            return;
        }
        Entity from = client.f_91073_.m_6815_(fromId);
        if (from instanceof RopeKnotEntity) {
            RopeKnotEntity fromKnot = (RopeKnotEntity)from;
            for (int toId : toIds) {
                Entity to = client.f_91073_.m_6815_(toId);
                if (to == null) {
                    incompleteRopes.add((Object)new IncompleteRopeConnection(fromKnot, toId));
                    continue;
                }
                if (!(to instanceof Entity)) continue;
                RopeConnection.create(fromKnot, to);
            }
        }
    }

    public static double getYHanging(double d, Vec3 ropeVec) {
        if (ropeVec.f_82479_ == 0.0 && ropeVec.f_82481_ == 0.0) {
            return 0.0;
        }
        double dXZ = Math.sqrt(ropeVec.f_82479_ * ropeVec.f_82479_ + ropeVec.f_82481_ * ropeVec.f_82481_);
        double a = 1.0 - 1.0 / (0.1 * dXZ + 1.0);
        double p = Math.PI / dXZ;
        return -a * Math.sin(p * d);
    }
}

