/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.satisfy.brewery.core.effect.BlackoutEffect;
import net.satisfy.brewery.core.effect.CombustionEffect;
import net.satisfy.brewery.core.effect.DrunkEffect;
import net.satisfy.brewery.core.effect.ExplosionEffect;
import net.satisfy.brewery.core.effect.HaleyEffect;
import net.satisfy.brewery.core.effect.HealingTouchEffect;
import net.satisfy.brewery.core.effect.LightningStrikeEffect;
import net.satisfy.brewery.core.effect.MiningEffect;
import net.satisfy.brewery.core.effect.PacifyEffect;
import net.satisfy.brewery.core.effect.PartystarterEffect;
import net.satisfy.brewery.core.effect.PintCharismaEffect;
import net.satisfy.brewery.core.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.core.effect.RenewingTouchEffect;
import net.satisfy.brewery.core.effect.RepulsionEffect;
import net.satisfy.brewery.core.effect.SnowWhiteEffect;
import net.satisfy.brewery.core.effect.ToxicTouchEffect;
import net.satisfy.brewery.core.util.BreweryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> DRUNK = MobEffectRegistry.registerEffect("drunk", DrunkEffect::new);
    public static final RegistrySupplier<MobEffect> BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().m_216879_(() -> new MobEffectInstance.FactorData(22)));
    public static final RegistrySupplier<MobEffect> RENEWINGTOUCH;
    public static final RegistrySupplier<MobEffect> TOXICTOUCH;
    public static final RegistrySupplier<MobEffect> HEALINGTOUCH;
    public static final RegistrySupplier<MobEffect> PROTECTIVETOUCH;
    public static final RegistrySupplier<MobEffect> PARTYSTARTER;
    public static final RegistrySupplier<MobEffect> SNOWWHITE;
    public static final RegistrySupplier<MobEffect> PINTCHARISMA;
    public static final RegistrySupplier<MobEffect> HALEY;
    public static final RegistrySupplier<MobEffect> MINING;
    public static final RegistrySupplier<MobEffect> PACIFY;
    public static final RegistrySupplier<MobEffect> COMBUSTION;
    public static final RegistrySupplier<MobEffect> EXPLOSION;
    public static final RegistrySupplier<MobEffect> REPULSION;
    public static final RegistrySupplier<MobEffect> LIGHTNING_STRIKE;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new BreweryIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    static {
        MINING = MobEffectRegistry.registerEffect("mining", () -> new MiningEffect(MobEffectCategory.BENEFICIAL, 0));
        PACIFY = MobEffectRegistry.registerEffect("pacify", () -> new PacifyEffect(MobEffectCategory.BENEFICIAL, 0));
        REPULSION = MobEffectRegistry.registerEffect("repulsion", () -> new RepulsionEffect(MobEffectCategory.BENEFICIAL, 0));
        LIGHTNING_STRIKE = MobEffectRegistry.registerEffect("lightning_strike", () -> new LightningStrikeEffect(MobEffectCategory.BENEFICIAL, 0));
        EXPLOSION = MobEffectRegistry.registerEffect("explosion", () -> new ExplosionEffect(MobEffectCategory.BENEFICIAL, 0));
        COMBUSTION = MobEffectRegistry.registerEffect("combustion", () -> new CombustionEffect(MobEffectCategory.BENEFICIAL, 0));
        TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(MobEffectCategory.BENEFICIAL, 0));
        SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(MobEffectCategory.BENEFICIAL, 0));
        PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(MobEffectCategory.BENEFICIAL, 0));
        HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(MobEffectCategory.BENEFICIAL, 0));
    }
}

