/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BrewingRecipe
implements Recipe<Container> {
    private final ResourceLocation identifier;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final BrewMaterial material;

    public BrewingRecipe(ResourceLocation identifier, NonNullList<Ingredient> ingredients, ItemStack output, BrewMaterial material) {
        this.identifier = identifier;
        this.ingredients = ingredients;
        this.output = output;
        this.material = material;
    }

    public BrewMaterial getMaterial() {
        return this.material;
    }

    public boolean m_5818_(Container inventory, Level world) {
        StackedContents recipeMatcher = new StackedContents();
        int matchingStacks = 0;
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            ++matchingStacks;
            recipeMatcher.m_36468_(itemStack, 1);
        }
        return matchingStacks == this.ingredients.size() && recipeMatcher.m_36475_((Recipe)this, null);
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.identifier;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.BREWING_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < json.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        @NotNull
        public BrewingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            NonNullList<Ingredient> ingredients = Serializer.deserializeIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Brewing");
            }
            if (ingredients.size() > 3) {
                throw new JsonParseException("Too many ingredients for Brewing");
            }
            BrewMaterial brewMaterial = BrewMaterial.valueOf(jsonObject.get("material").getAsString());
            return new BrewingRecipe(resourceLocation, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result")), brewMaterial);
        }

        @NotNull
        public BrewingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            return new BrewingRecipe(id, (NonNullList<Ingredient>)ingredients, buf.m_130267_(), (BrewMaterial)buf.m_130066_(BrewMaterial.class));
        }

        public void toNetwork(FriendlyByteBuf buf, BrewingRecipe recipe) {
            buf.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
            buf.m_130068_((Enum)recipe.material);
        }
    }
}

