/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={ServerPlayer.class}, priority=1031)
public abstract class ServerPlayerMixin {
    private static final ThreadLocal<Boolean> IGNORE_XP_INJECTION = ThreadLocal.withInitial(() -> false);

    @Inject(method={"mayInteract"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodMayInteract(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (!((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() && ModBlocks.isAnyGrave(level.m_8055_(pos).m_60734_())) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"giveExperiencePoints"}, at={@At(value="HEAD")}, cancellable=true)
    public void methodGiveExperiencePoints(int amount, CallbackInfo callbackInfo) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (amount > 0 && !IGNORE_XP_INJECTION.get().booleanValue() && serverPlayer.m_6084_() && serverPlayer.m_21023_(ModEffects.remanence)) {
            MobEffectInstance effectInstance = serverPlayer.m_21124_(ModEffects.remanence);
            assert (effectInstance != null);
            int xpBonus = Math.round((float)amount * 0.1f * (float)(effectInstance.m_19564_() + 1));
            if (xpBonus <= 0) {
                return;
            }
            IGNORE_XP_INJECTION.set(true);
            serverPlayer.m_6756_(amount + xpBonus);
            IGNORE_XP_INJECTION.set(false);
            callbackInfo.cancel();
        }
    }
}

