/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModDamages;

public class DecrepitudeEffect
extends TombstoneEffect {
    private static final String SPEED_MODIFIER = "b3a3799b-4bcd-4100-8469-645989809f4a";
    private static final String DECREPITUDE_APPLIER = "decrepitude_applier";

    public DecrepitudeEffect() {
        super(MobEffectCategory.HARMFUL, -8835971);
        this.m_19472_(Attributes.f_22279_, SPEED_MODIFIER, -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.noAttributeScale();
    }

    @Override
    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            LivingEntity livingEntity2;
            CompoundTag tag = livingEntity.getPersistentData();
            if (livingEntity.m_21213_() == livingEntity.f_19797_ && (livingEntity2 = livingEntity.m_21188_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                tag.m_128362_(DECREPITUDE_APPLIER, serverPlayer.m_20148_());
            } else {
                tag.m_128473_(DECREPITUDE_APPLIER);
            }
        }
    }

    @Override
    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        CompoundTag tag;
        super.onEffectFinished(livingEntity, effectInstance);
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_() && (tag = livingEntity.getPersistentData()).m_128441_(DECREPITUDE_APPLIER)) {
            tag.m_128473_(DECREPITUDE_APPLIER);
        }
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerPlayer player;
            MinecraftServer server;
            LivingEntity attacker = livingEntity;
            CompoundTag tag = livingEntity.getPersistentData();
            if (tag.m_128441_(DECREPITUDE_APPLIER) && (server = livingEntity.m_20194_()) != null && (player = server.m_6846_().m_11259_(tag.m_128342_(DECREPITUDE_APPLIER))) != null) {
                attacker = player;
            }
            Helper.hurtWithoutCooldown(livingEntity, ModDamages.sourceUnholy((Entity)attacker), Math.min((float)((Integer)ConfigTombstone.general.decrepitudeMaxDamage.get()).intValue(), Math.min((float)(amplifier + 1) * 0.01f, 0.4f) * livingEntity.m_21233_()));
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return duration % 40 == 0;
    }
}

