/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.block.entity.BlockWritableGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;

public final class BlockEntityDecorativeGrave
extends BlockWritableGrave {
    private long lastCheckSoul = -1L;
    private long lastCheckCorruption = -1L;
    private int corruptionLevel = 0;
    private boolean isScreaming = false;
    private long lastRiteTicks = -1L;
    public static final List<BlockPos> PARTICLE_OFFSETS = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.m_123341_()) == 2 || Math.abs(pos.m_123343_()) == 2).map(BlockPos::m_7949_).toList();

    public BlockEntityDecorativeGrave(BlockPos pos, BlockState state) {
        super(ModBlocks.tile_decorative_grave, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        SoulType soulType;
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        if (grave.isScreaming()) {
            Random random = Helper.RANDOM;
            for (BlockPos currentPos : PARTICLE_OFFSETS) {
                if (random.nextInt(1000) != 0) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)currentPos.m_123341_() + random.nextFloat()) - 0.5, (double)((float)currentPos.m_123342_() - random.nextFloat()) - 1.0, (double)((float)currentPos.m_123343_() + random.nextFloat()) - 0.5);
            }
        } else if (TimeHelper.atInterval(grave.countTicks, 25) && (soulType = (SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
            ModTombstone.PROXY.produceGraveSoul(level, pos, soulType, (int)(grave.countTicks % 100L / 25L));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        int checkCount;
        int checkInterval;
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        long serverGlobalTime = GlobalClock.INSTANCE.getTime(level);
        if (grave.corruptionLevel > 0) {
            if (grave.lastCheckCorruption <= 0L || grave.lastCheckCorruption > serverGlobalTime) {
                grave.lastCheckCorruption = serverGlobalTime;
            } else {
                checkInterval = TimeHelper.isDateAroundSpringBloom() ? 1200 : 12000;
                checkCount = (int)(serverGlobalTime - grave.lastCheckCorruption) / checkInterval;
                if (checkCount > 0) {
                    grave.decreaseCorruption(checkCount);
                    grave.lastCheckCorruption += (long)checkCount * (long)checkInterval;
                }
            }
        }
        if (grave.isScreaming() && TimeHelper.atInterval(serverGlobalTime, 900)) {
            level.m_5594_(null, pos, ModSounds.soul_whisper, SoundSource.AMBIENT, 0.4f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            if (Helper.RANDOM.nextBoolean()) {
                Vec3 centerVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 1.0, 0.5);
                Player closestPlayer = level.m_45924_(centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_, 20.0, false);
                if (closestPlayer != null && Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                    Snowball snowball = new Snowball(level, centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_);
                    snowball.m_37446_(new ItemStack((ItemLike)Items.f_42500_));
                    snowball.getPersistentData().m_128379_("slowing_bone", true);
                    float projectileSpeed = 0.5f;
                    Vec3 vec = Helper.calculateDirectionForProjectile((ThrowableProjectile)snowball, projectileSpeed, (Entity)closestPlayer);
                    snowball.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, projectileSpeed, 1.0f);
                    level.m_7967_((Entity)snowball);
                }
            }
        }
        if (grave.lastCheckSoul <= 0L || grave.lastCheckSoul > serverGlobalTime || grave.isScreaming()) {
            grave.lastCheckSoul = serverGlobalTime;
            return;
        }
        checkInterval = TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.soulTime.get());
        checkCount = (int)(serverGlobalTime - grave.lastCheckSoul) / checkInterval;
        if (checkCount > 0) {
            if (((SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                grave.resetCheckSoul();
                return;
            }
            double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.soulChance.get()).intValue() / 100.0, checkCount);
            if (chance >= 1.0 || Helper.RANDOM.nextDouble() <= chance) {
                SoulType soulType;
                LightningBolt bolt;
                if (checkCount == 1 && grave.lastCheckSoul == serverGlobalTime + (long)checkInterval && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    bolt.m_20874_(true);
                    level.m_7967_((Entity)bolt);
                }
                if ((soulType = SoulType.generateSoulType()) == SoulType.STRONG && ((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue() && Helper.RANDOM.nextBoolean() && EntityHelper.noGraveGuardianAround(level, pos)) {
                    Helper.spawnGraveGuardian(level, pos);
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_(BlockDecorativeGrave.SOUL_TYPE, (Comparable)((Object)soulType)));
                }
                grave.lastCheckSoul += (long)checkCount * (long)checkInterval;
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    public boolean isScreaming() {
        return this.isScreaming;
    }

    public void setScreaming(boolean flag) {
        if (this.isScreaming() != flag) {
            this.isScreaming = flag;
            this.m_6596_();
            if (this.f_58857_ != null) {
                BlockState state = this.m_58900_();
                this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            }
        }
    }

    public int getCorruptionLevel() {
        return this.corruptionLevel;
    }

    public void increaseCorruption(int amount) {
        if (!this.isScreaming()) {
            this.corruptionLevel = Mth.m_14045_((int)(this.corruptionLevel + amount), (int)0, (int)100);
            this.m_6596_();
            if (this.corruptionLevel == 100) {
                this.setScreaming(true);
            }
        }
    }

    public void decreaseCorruption(int amount) {
        Level level;
        this.corruptionLevel = Math.max(0, this.corruptionLevel - amount);
        if (this.corruptionLevel == 0) {
            this.setScreaming(false);
        }
        if (amount > 1 && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5, 8, 0.3, 0.0, 0.3, 0.1);
        }
    }

    public boolean applySpammingRite() {
        if (this.f_58857_ != null) {
            long serverGlobalTime = GlobalClock.INSTANCE.getTime(this.f_58857_);
            if (this.lastRiteTicks > 0L && this.lastRiteTicks < serverGlobalTime && !TimeHelper.isMinuteElapsed(serverGlobalTime, this.lastRiteTicks, 5)) {
                this.increaseCorruption(15);
                return true;
            }
            this.lastRiteTicks = serverGlobalTime;
        }
        return false;
    }

    public boolean applyScreaming(ServerPlayer serverPlayer) {
        if (this.isScreaming()) {
            LangKey.MESSAGE_SCREAMING_GRAVE.sendMessage((Player)serverPlayer, new Object[0]);
            serverPlayer.m_284548_().m_5594_(null, this.m_58899_(), SoundEvents.f_11922_, SoundSource.BLOCKS, 0.5f, 0.8f + Helper.RANDOM.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.m_128356_("lastCheckSoul", this.lastCheckSoul);
        }
        compound.m_128379_("is_screaming", this.isScreaming());
        compound.m_128405_("corruption_level", this.corruptionLevel);
        if (this.lastRiteTicks > 0L) {
            compound.m_128356_("last_rite_ticks", this.lastRiteTicks);
        }
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.m_128454_("lastCheckSoul");
        }
        if (compound.m_128441_("is_screaming")) {
            this.isScreaming = compound.m_128471_("is_screaming");
        }
        if (compound.m_128425_("corruption_level", 3)) {
            this.corruptionLevel = compound.m_128451_("corruption_level");
        }
        if (compound.m_128425_("last_rite_ticks", 4)) {
            this.lastRiteTicks = compound.m_128454_("last_rite_ticks");
        }
    }
}

