/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.everythingcopper.EverythingCopper;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ScrapeRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final Ingredient input;

    public ScrapeRecipe(ResourceLocation id, Ingredient input) {
        this.id = id;
        this.input = input;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean hasValidItem = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (!itemStack.m_41619_() && this.input.test(itemStack) && (ICopperItem.isWaxed(itemStack) || !ICopperItem.getAge(itemStack).equals("unaffected"))) {
                hasValidItem = true;
                continue;
            }
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return hasValidItem;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack outputItem = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_() || !this.input.test(itemStack)) continue;
            outputItem = itemStack.m_41777_();
        }
        if (ICopperItem.isWaxed(outputItem)) {
            ICopperItem.setWaxed(outputItem, false);
        } else {
            ICopperItem.setAge(outputItem, WeatheringUtils.prevState(ICopperItem.getAge(outputItem)));
        }
        return outputItem;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.input.m_43908_().length > 0 ? this.input.m_43908_()[0] : ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.input);
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.SCRAPE.get();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer<T extends ScrapeRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient input = GsonHelper.m_13885_((JsonObject)json, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            return this.factory.create(id, input);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error reading scraping recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((ScrapeRecipe)recipe).input.m_43923_(buffer);
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error writing scraping recipe to packet. " + ((ScrapeRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ScrapeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2);
        }
    }
}

