/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.item;

import cy.jdkdigital.everythingcopper.init.ModTags;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.NotNull;

public interface ICopperItem {
    public static final Tier COPPER_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(2, 180, 7.0f, 1.8f, 18, ModTags.NEEDS_COPPER_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_})), (ResourceLocation)new ResourceLocation("everythingcopper", "copper"), List.of(Tiers.WOOD, Tiers.STONE), List.of(Tiers.DIAMOND, Tiers.NETHERITE));
    public static final ArmorMaterial COPPER_MATERIAL = new ArmorMaterial(){

        public int m_266425_(ArmorItem.Type type) {
            HashMap<ArmorItem.Type, Integer> HEALTH = new HashMap<ArmorItem.Type, Integer>(){
                {
                    this.put(ArmorItem.Type.BOOTS, 12);
                    this.put(ArmorItem.Type.LEGGINGS, 14);
                    this.put(ArmorItem.Type.CHESTPLATE, 15);
                    this.put(ArmorItem.Type.HELMET, 10);
                }
            };
            return (Integer)HEALTH.get(type) * 12;
        }

        public int m_7366_(ArmorItem.Type type) {
            HashMap<ArmorItem.Type, Integer> DEFENSE = new HashMap<ArmorItem.Type, Integer>(){
                {
                    this.put(ArmorItem.Type.BOOTS, 2);
                    this.put(ArmorItem.Type.LEGGINGS, 4);
                    this.put(ArmorItem.Type.CHESTPLATE, 5);
                    this.put(ArmorItem.Type.HELMET, 2);
                }
            };
            return (Integer)DEFENSE.get(type);
        }

        public int m_6646_() {
            return 12;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_});
        }

        @NotNull
        public String m_6082_() {
            return "copper";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.1f;
        }
    };

    default public void weatheringTick(ItemStack stack, Level level) {
        if (ICopperItem.canAge(stack) && level.f_46441_.m_188501_() < 1.8962963E-4f) {
            ICopperItem.setAge(stack, WeatheringUtils.nextState(ICopperItem.getAge(stack)));
        }
    }

    public static boolean isWaxed(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("waxed")) {
            return tag.m_128471_("waxed");
        }
        return false;
    }

    public static void setWaxed(ItemStack stack, boolean waxed) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("waxed", waxed);
        stack.m_41751_(tag);
    }

    public static boolean canAge(ItemStack stack) {
        return !ICopperItem.isWaxed(stack) && !ICopperItem.getAge(stack).equals("oxidized");
    }

    public static String getAge(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("state") && !tag.m_128461_("state").isEmpty()) {
            return tag.m_128461_("state");
        }
        return "unaffected";
    }

    public static void setAge(ItemStack stack, String age) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("state", age);
        stack.m_41751_(tag);
    }

    public static Float getStateAsFloat(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("state") && !tag.m_128461_("state").isEmpty()) {
            return switch (tag.m_128461_("state")) {
                case "exposed" -> Float.valueOf(1.0f);
                case "weathered" -> Float.valueOf(2.0f);
                case "oxidized" -> Float.valueOf(3.0f);
                default -> Float.valueOf(0.0f);
            };
        }
        return Float.valueOf(0.0f);
    }
}

