/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public interface IWeatheringBlock
extends WeatheringCopper {
    public static Optional<BlockState> getWaxed(BlockState blockState) {
        WeatheringUtils.buildWaxBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.WAX_ON_BY_BLOCK.get().get((Object)blockState.m_60734_())).map(block -> block.m_152465_(blockState));
    }

    public static Optional<BlockState> getUnwaxed(BlockState state) {
        WeatheringUtils.buildWaxBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.WAX_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    @NotNull
    default public Optional<BlockState> m_142123_(BlockState blockState) {
        return IWeatheringBlock.getNext(blockState.m_60734_()).map(block -> block.m_152465_(blockState));
    }

    public static Optional<Block> getNext(Block block) {
        WeatheringUtils.buildBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.NEXT_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<Block> getPrevious(Block block) {
        WeatheringUtils.buildBlockMap();
        return Optional.ofNullable((Block)WeatheringUtils.PREVIOUS_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return IWeatheringBlock.getPrevious(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public InteractionResult applyWax(BlockState blockState, Level level, BlockPos blockpos, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HoneycombItem) {
            return IWeatheringBlock.getWaxed(blockState).map(waxedBlockState -> {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (blockState.m_61138_((Property)DoorBlock.f_52730_)) {
                    BlockPos replacedPosition = blockpos;
                    if (((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.UPPER)) {
                        replacedPosition = replacedPosition.m_7495_();
                    }
                    level.m_7731_(replacedPosition, Blocks.f_50016_.m_49966_(), 3);
                    level.m_7731_(replacedPosition, (BlockState)waxedBlockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 2);
                    level.m_7731_(replacedPosition.m_7494_(), (BlockState)waxedBlockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 11);
                    level.m_5898_(player, 3003, replacedPosition, 0);
                    level.m_5898_(player, 3003, replacedPosition.m_7494_(), 0);
                } else {
                    level.m_7731_(blockpos, waxedBlockState, 11);
                    level.m_5898_(player, 3003, blockpos, 0);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }
}

