/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.network;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.util.TriConsumer;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.network.MsgAddRenderLinkS2C;
import ram.talia.hexal.common.network.MsgParticleLinesAck;
import ram.talia.hexal.common.network.MsgRemoveEverbookS2C;
import ram.talia.hexal.common.network.MsgRemoveRenderLinkS2C;
import ram.talia.hexal.common.network.MsgSendEverbookC2S;
import ram.talia.hexal.common.network.MsgSetEverbookS2C;
import ram.talia.hexal.common.network.MsgSetRenderLinksAck;
import ram.talia.hexal.common.network.MsgSingleParticleAck;
import ram.talia.hexal.common.network.MsgToggleMacroS2C;
import ram.talia.hexal.common.network.MsgWispCastSoundS2C;

public class ForgePacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)HexalAPI.modLoc("main"), () -> "1", "1"::equals, "1"::equals);

    public static SimpleChannel getNetwork() {
        return NETWORK;
    }

    public static void init() {
        int messageIdx = 0;
        NETWORK.registerMessage(messageIdx++, MsgSendEverbookC2S.class, MsgSendEverbookC2S::serialize, MsgSendEverbookC2S::deserialise, ForgePacketHandler.makeServerBoundHandler(MsgSendEverbookC2S::handle));
        NETWORK.registerMessage(messageIdx++, MsgSetEverbookS2C.class, MsgSetEverbookS2C::serialize, MsgSetEverbookS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSetEverbookS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgRemoveEverbookS2C.class, MsgRemoveEverbookS2C::serialize, MsgRemoveEverbookS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgRemoveEverbookS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgToggleMacroS2C.class, MsgToggleMacroS2C::serialize, MsgToggleMacroS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgToggleMacroS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgWispCastSoundS2C.class, MsgWispCastSoundS2C::serialize, MsgWispCastSoundS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgWispCastSoundS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgAddRenderLinkS2C.class, MsgAddRenderLinkS2C::serialize, MsgAddRenderLinkS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgAddRenderLinkS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgRemoveRenderLinkS2C.class, MsgRemoveRenderLinkS2C::serialize, MsgRemoveRenderLinkS2C::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgRemoveRenderLinkS2C::handle));
        NETWORK.registerMessage(messageIdx++, MsgSetRenderLinksAck.class, MsgSetRenderLinksAck::serialize, MsgSetRenderLinksAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSetRenderLinksAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgSingleParticleAck.class, MsgSingleParticleAck::serialize, MsgSingleParticleAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgSingleParticleAck::handle));
        NETWORK.registerMessage(messageIdx++, MsgParticleLinesAck.class, MsgParticleLinesAck::serialize, MsgParticleLinesAck::deserialise, ForgePacketHandler.makeClientBoundHandler(MsgParticleLinesAck::handle));
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeServerBoundHandler(TriConsumer<T, MinecraftServer, ServerPlayer> handler) {
        return (m, ctx) -> {
            handler.accept(m, (Object)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()).m_20194_(), (Object)((NetworkEvent.Context)ctx.get()).getSender());
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeClientBoundHandler(Consumer<T> consumer) {
        return (m, ctx) -> {
            consumer.accept(m);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }
}

