/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.eventhandlers;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.casting.wisp.WispCastingManager;
import ram.talia.hexal.common.entities.BaseCastingWisp;

public class WispCastingMangerEventHandler {
    private static final String TAG_CASTING_MANAGER = "hexal:casting_manager";
    private static final String TAG_SEON = "hexal:seon";
    private static final Map<UUID, WispCastingManager> castingManagers = new HashMap<UUID, WispCastingManager>();
    private static final Map<UUID, UUID> seonUUIDs = new HashMap<UUID, UUID>();
    private static final Map<UUID, WeakReference<BaseCastingWisp>> seons = new HashMap<UUID, WeakReference<BaseCastingWisp>>();

    public static WispCastingManager getCastingManager(ServerPlayer serverPlayer) {
        WispCastingManager manager = castingManagers.get(serverPlayer.m_20148_());
        if (manager == null) {
            manager = WispCastingMangerEventHandler.loadCastingManager(serverPlayer);
            castingManagers.put(serverPlayer.m_20148_(), manager);
        }
        return manager;
    }

    private static WispCastingManager loadCastingManager(ServerPlayer player) {
        WispCastingManager manager = new WispCastingManager(player);
        manager.readFromNbt(player.getPersistentData().m_128469_(TAG_CASTING_MANAGER), player.m_284548_());
        return manager;
    }

    @Nullable
    public static BaseCastingWisp getSeon(ServerPlayer player) {
        WeakReference<BaseCastingWisp> ref = seons.get(player.m_20148_());
        if (ref == null) {
            return WispCastingMangerEventHandler.refreshSeonFromLevel(player);
        }
        return (BaseCastingWisp)ref.get();
    }

    public static void setSeon(ServerPlayer player, @Nullable BaseCastingWisp wisp) {
        WeakReference<BaseCastingWisp> oldRef = seons.get(player.m_20148_());
        if (oldRef == null) {
            BaseCastingWisp oldSeon = WispCastingMangerEventHandler.refreshSeonFromLevel(player);
            if (oldSeon != null) {
                oldSeon.setSeon(false);
            }
        } else {
            BaseCastingWisp oldSeon = (BaseCastingWisp)oldRef.get();
            if (oldSeon != null) {
                oldSeon.setSeon(false);
            }
        }
        if (wisp != null) {
            wisp.setSeon(true);
            seonUUIDs.put(player.m_20148_(), wisp.m_20148_());
            seons.put(player.m_20148_(), new WeakReference<BaseCastingWisp>(wisp));
        } else {
            seonUUIDs.remove(player.m_20148_());
            seons.remove(player.m_20148_());
        }
    }

    private static void loadSeon(ServerPlayer player) {
        if (!player.getPersistentData().m_128403_(TAG_SEON)) {
            return;
        }
        UUID seonUUID = player.getPersistentData().m_128342_(TAG_SEON);
        Entity entity = player.m_284548_().m_8791_(seonUUID);
        if (entity == null) {
            seonUUIDs.put(player.m_20148_(), seonUUID);
            return;
        }
        if (entity instanceof BaseCastingWisp) {
            BaseCastingWisp seon = (BaseCastingWisp)entity;
            seonUUIDs.put(player.m_20148_(), seonUUID);
            seons.put(player.m_20148_(), new WeakReference<BaseCastingWisp>(seon));
        }
    }

    @Nullable
    private static BaseCastingWisp refreshSeonFromLevel(ServerPlayer player) {
        UUID seonUUID = seonUUIDs.get(player.m_20148_());
        if (seonUUID == null) {
            return null;
        }
        Entity entity = player.m_284548_().m_8791_(seonUUID);
        if (!(entity instanceof BaseCastingWisp)) {
            return null;
        }
        BaseCastingWisp seon = (BaseCastingWisp)entity;
        seons.put(player.m_20148_(), new WeakReference<BaseCastingWisp>(seon));
        return seon;
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        castingManagers.put(player.m_20148_(), WispCastingMangerEventHandler.loadCastingManager(player));
        WispCastingMangerEventHandler.loadSeon(player);
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        CompoundTag tag = new CompoundTag();
        WispCastingMangerEventHandler.getCastingManager(player).writeToNbt(tag);
        player.getPersistentData().m_128365_(TAG_CASTING_MANAGER, (Tag)tag);
        UUID seonUUID = seonUUIDs.get(player.m_20148_());
        if (seonUUID != null) {
            player.getPersistentData().m_128362_(TAG_SEON, seonUUID);
        }
        castingManagers.remove(player.m_20148_());
        seonUUIDs.remove(player.m_20148_());
        seons.remove(player.m_20148_());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        WispCastingMangerEventHandler.getCastingManager(player).executeCasts();
    }
}

