/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.datagen;

import at.petrak.hexcasting.forge.datagen.TagsProviderEFHSetter;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.lib.HexalSounds;
import ram.talia.hexal.datagen.HexalBlockTagProvider;
import ram.talia.hexal.datagen.HexalLootTables;
import ram.talia.hexal.datagen.recipes.HexalplatRecipes;
import ram.talia.hexal.datagen.tag.HexalActionTagProvider;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lram/talia/hexal/forge/datagen/HexalForgeDataGenerators;", "", "()V", "Companion", "hexal-forge-1.20.1"})
public final class HexalForgeDataGenerators {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @SubscribeEvent
    public static final void generateData(@NotNull GatherDataEvent ev) {
        Companion.generateData(ev);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lram/talia/hexal/forge/datagen/HexalForgeDataGenerators$Companion;", "", "()V", "configureForgeDatagen", "", "ev", "Lnet/minecraftforge/data/event/GatherDataEvent;", "configureXplatDatagen", "generateData", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @SubscribeEvent
        public final void generateData(@NotNull GatherDataEvent ev) {
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            if (System.getProperty("hexal.xplat_datagen") != null) {
                this.configureXplatDatagen(ev);
            }
            if (System.getProperty("hexal.forge_datagen") != null) {
                this.configureForgeDatagen(ev);
            }
        }

        private final void configureXplatDatagen(GatherDataEvent ev) {
            HexalAPI.LOGGER.info("Starting cross-platform datagen");
            DataGenerator gen = ev.getGenerator();
            PackOutput output = gen.getPackOutput();
            gen.addProvider(ev.includeClient(), (DataProvider)HexalSounds.provider(output));
        }

        private final void configureForgeDatagen(GatherDataEvent ev) {
            HexalAPI.LOGGER.info("Starting Forge-specific datagen");
            DataGenerator gen = ev.getGenerator();
            PackOutput output = gen.getPackOutput();
            CompletableFuture lookup = ev.getLookupProvider();
            ExistingFileHelper efh = ev.getExistingFileHelper();
            gen.addProvider(ev.includeServer(), (DataProvider)new LootTableProvider(output, SetsKt.emptySet(), CollectionsKt.listOf((Object)new LootTableProvider.SubProviderEntry(HexalLootTables::new, LootContextParamSets.f_81420_))));
            boolean bl = ev.includeServer();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
            gen.addProvider(bl, (DataProvider)new HexalplatRecipes(output));
            Intrinsics.checkNotNullExpressionValue((Object)lookup, (String)"lookup");
            HexalBlockTagProvider blockTagProvider = new HexalBlockTagProvider(output, lookup);
            ((TagsProviderEFHSetter)blockTagProvider).setEFH(efh);
            gen.addProvider(ev.includeServer(), (DataProvider)blockTagProvider);
            HexalActionTagProvider hexTagProvider = new HexalActionTagProvider(output, lookup);
            ((TagsProviderEFHSetter)hexTagProvider).setEFH(efh);
            gen.addProvider(ev.includeServer(), (DataProvider)hexTagProvider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

