/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.network;

import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.linkable.ClientLinkableHolder;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.client.LinkablePacketHolder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lram/talia/hexal/common/network/MsgSetRenderLinksAck;", "Lat/petrak/hexcasting/common/msgs/IMessage;", "sourceLink", "Lram/talia/hexal/api/linkable/ILinkable;", "sinks", "", "(Lram/talia/hexal/api/linkable/ILinkable;Ljava/util/List;)V", "sourceLinkTag", "Lnet/minecraft/nbt/CompoundTag;", "sinksTag", "Lnet/minecraft/nbt/ListTag;", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/nbt/ListTag;)V", "getSinksTag", "()Lnet/minecraft/nbt/ListTag;", "getSourceLinkTag", "()Lnet/minecraft/nbt/CompoundTag;", "getFabricId", "Lnet/minecraft/resources/ResourceLocation;", "serialize", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "Companion", "hexal-forge-1.20.1"})
public final class MsgSetRenderLinksAck
implements IMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundTag sourceLinkTag;
    @NotNull
    private final ListTag sinksTag;
    @JvmField
    @NotNull
    public static final ResourceLocation ID;
    @NotNull
    public static final String TAG_SOURCE_LINK = "source";
    @NotNull
    public static final String TAG_SINKS = "sinks";

    public MsgSetRenderLinksAck(@NotNull CompoundTag sourceLinkTag, @NotNull ListTag sinksTag) {
        Intrinsics.checkNotNullParameter((Object)sourceLinkTag, (String)"sourceLinkTag");
        Intrinsics.checkNotNullParameter((Object)sinksTag, (String)"sinksTag");
        this.sourceLinkTag = sourceLinkTag;
        this.sinksTag = sinksTag;
    }

    @NotNull
    public final CompoundTag getSourceLinkTag() {
        return this.sourceLinkTag;
    }

    @NotNull
    public final ListTag getSinksTag() {
        return this.sinksTag;
    }

    public MsgSetRenderLinksAck(@NotNull ILinkable sourceLink, @NotNull List<? extends ILinkable> sinks) {
        Intrinsics.checkNotNullParameter((Object)sourceLink, (String)"sourceLink");
        Intrinsics.checkNotNullParameter(sinks, (String)TAG_SINKS);
        this(LinkableRegistry.wrapSync(sourceLink), HexalNBTHelperKt.toSyncTagILinkable(sinks));
    }

    @NotNull
    public ResourceLocation getFabricId() {
        return ID;
    }

    public void serialize(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(TAG_SOURCE_LINK, (Tag)this.sourceLinkTag);
        tag.m_128365_(TAG_SINKS, (Tag)this.sinksTag);
        buf.m_130079_(tag);
    }

    @JvmStatic
    @NotNull
    public static final MsgSetRenderLinksAck deserialise(@NotNull ByteBuf buffer) {
        return Companion.deserialise(buffer);
    }

    @JvmStatic
    public static final void handle(@NotNull MsgSetRenderLinksAck self) {
        Companion.handle(self);
    }

    static {
        ResourceLocation resourceLocation = HexalAPI.modLoc("rslinks");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"modLoc(\"rslinks\")");
        ID = resourceLocation;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lram/talia/hexal/common/network/MsgSetRenderLinksAck$Companion;", "", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "TAG_SINKS", "", "TAG_SOURCE_LINK", "deserialise", "Lram/talia/hexal/common/network/MsgSetRenderLinksAck;", "buffer", "Lio/netty/buffer/ByteBuf;", "handle", "", "self", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MsgSetRenderLinksAck deserialise(@NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            CompoundTag compoundTag = buf.m_130260_();
            if (compoundTag == null) {
                throw new NullPointerException("no Nbt tag on received MsgSetRenderLinksAck");
            }
            CompoundTag tag = compoundTag;
            Tag tag2 = tag.m_128423_(MsgSetRenderLinksAck.TAG_SOURCE_LINK);
            CompoundTag compoundTag2 = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
            if (compoundTag2 == null) {
                throw new NullPointerException("no sourceLinkTag on received MsgSetRenderLinksAck");
            }
            tag2 = tag.m_128423_(MsgSetRenderLinksAck.TAG_SINKS);
            ListTag listTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
            if (listTag == null) {
                throw new NullPointerException("no sinks on received MsgSetRenderLinksAck");
            }
            return new MsgSetRenderLinksAck(compoundTag2, listTag);
        }

        @JvmStatic
        public final void handle(@NotNull MsgSetRenderLinksAck self) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Minecraft.m_91087_().execute(() -> Companion.handle$lambda$0(self));
        }

        private static final void handle$lambda$0(MsgSetRenderLinksAck $self) {
            Intrinsics.checkNotNullParameter((Object)$self, (String)"$self");
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            ListTag listTag = $self.getSinksTag();
            ClientLevel clientLevel = mc.f_91073_;
            Intrinsics.checkNotNull((Object)clientLevel);
            Map<CompoundTag, ILinkable.IRenderCentre> sinks = HexalNBTHelperKt.toIRenderCentreMap(listTag, clientLevel);
            CompoundTag compoundTag = $self.getSourceLinkTag();
            ClientLevel clientLevel2 = mc.f_91073_;
            Intrinsics.checkNotNull((Object)clientLevel2);
            Object object = LinkableRegistry.fromSync(compoundTag, (Level)clientLevel2);
            if (object != null && (object = object.getClientLinkableHolder()) != null) {
                ((ClientLinkableHolder)object).setRenderLinks(sinks);
            } else {
                LinkablePacketHolder.INSTANCE.schedule($self);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

