/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.network;

import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.everbook.Everbook;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.api.nbt.NbtSizeException;
import ram.talia.hexal.xplat.IXplatAbstractions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lram/talia/hexal/common/network/MsgSendEverbookC2S;", "Lat/petrak/hexcasting/common/msgs/IMessage;", "everbook", "Lram/talia/hexal/api/everbook/Everbook;", "(Lram/talia/hexal/api/everbook/Everbook;)V", "amountOverLimit", "", "getEverbook", "()Lram/talia/hexal/api/everbook/Everbook;", "somethingWeirdHappened", "", "wasTooBig", "component1", "copy", "equals", "other", "", "getFabricId", "Lnet/minecraft/resources/ResourceLocation;", "handle", "", "server", "Lnet/minecraft/server/MinecraftServer;", "sender", "Lnet/minecraft/server/level/ServerPlayer;", "hashCode", "", "serialize", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "toString", "", "Companion", "hexal-forge-1.20.1"})
public final class MsgSendEverbookC2S
implements IMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Everbook everbook;
    private boolean wasTooBig;
    private boolean somethingWeirdHappened;
    private long amountOverLimit;
    @JvmField
    @NotNull
    public static final ResourceLocation ID;
    @JvmField
    public static boolean isSingleplayer;

    public MsgSendEverbookC2S(@NotNull Everbook everbook) {
        Intrinsics.checkNotNullParameter((Object)everbook, (String)"everbook");
        this.everbook = everbook;
        this.amountOverLimit = -1L;
    }

    @NotNull
    public final Everbook getEverbook() {
        return this.everbook;
    }

    public void serialize(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        CompoundTag bookNbt = this.everbook.serialiseToNBT();
        byte[] bytes = HexalNBTHelperKt.toCompressedBytes(bookNbt);
        HexalAPI.LOGGER.info("Serialized everbook data of size " + bookNbt.m_263179_() + " compressed to size " + bytes.length);
        buf.m_130077_(this.everbook.getUuid());
        buf.m_130087_(bytes);
    }

    @NotNull
    public ResourceLocation getFabricId() {
        return ID;
    }

    public final void handle(@NotNull MinecraftServer server, @NotNull ServerPlayer sender) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        server.execute(() -> MsgSendEverbookC2S.handle$lambda$0(sender, this, server));
    }

    @NotNull
    public final Everbook component1() {
        return this.everbook;
    }

    @NotNull
    public final MsgSendEverbookC2S copy(@NotNull Everbook everbook) {
        Intrinsics.checkNotNullParameter((Object)everbook, (String)"everbook");
        return new MsgSendEverbookC2S(everbook);
    }

    public static /* synthetic */ MsgSendEverbookC2S copy$default(MsgSendEverbookC2S msgSendEverbookC2S, Everbook everbook, int n, Object object) {
        if ((n & 1) != 0) {
            everbook = msgSendEverbookC2S.everbook;
        }
        return msgSendEverbookC2S.copy(everbook);
    }

    @NotNull
    public String toString() {
        return "MsgSendEverbookC2S(everbook=" + this.everbook + ")";
    }

    public int hashCode() {
        return this.everbook.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MsgSendEverbookC2S)) {
            return false;
        }
        MsgSendEverbookC2S msgSendEverbookC2S = (MsgSendEverbookC2S)other;
        return Intrinsics.areEqual((Object)this.everbook, (Object)msgSendEverbookC2S.everbook);
    }

    private static final void handle$lambda$0(ServerPlayer $sender, MsgSendEverbookC2S this$0, MinecraftServer $server) {
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        Everbook everbook = this$0.everbook;
        ServerLevel serverLevel = $server.m_129783_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"server.overworld()");
        IXplatAbstractions.INSTANCE.setFullEverbook($sender, everbook.filterIotasIllegalInterworld(serverLevel));
        if (this$0.wasTooBig) {
            HexalAPI.LOGGER.info("Player " + $sender.m_5446_().getString() + "'s everbook data exceeded the configured size limit of " + HexalConfig.getServer().getEverbookMaxSize());
            Object[] objectArray = new Object[]{HexalConfig.getServer().getEverbookMaxSize()};
            $sender.m_213846_((Component)Component.m_237110_((String)"hexal.everbook.sizewarning", (Object[])objectArray));
        } else if (this$0.somethingWeirdHappened) {
            $sender.m_213846_((Component)Component.m_237115_((String)"hexal.everbook.unexpectederror"));
        } else if (isSingleplayer && this$0.amountOverLimit > 0L && $server.m_7416_() <= 1) {
            Object[] objectArray = new Object[]{HexalConfig.getServer().getEverbookMaxSize(), this$0.amountOverLimit};
            $sender.m_213846_((Component)Component.m_237110_((String)"hexal.everbook.overlimitsingleplayer", (Object[])objectArray));
        }
    }

    @JvmStatic
    @NotNull
    public static final MsgSendEverbookC2S deserialise(@NotNull ByteBuf buffer) {
        return Companion.deserialise(buffer);
    }

    static {
        ResourceLocation resourceLocation = HexalAPI.modLoc("sendever");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"modLoc(\"sendever\")");
        ID = resourceLocation;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lram/talia/hexal/common/network/MsgSendEverbookC2S$Companion;", "", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "isSingleplayer", "", "deserialise", "Lram/talia/hexal/common/network/MsgSendEverbookC2S;", "buffer", "Lio/netty/buffer/ByteBuf;", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MsgSendEverbookC2S deserialise(@NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            UUID uuid = buf.m_130259_();
            byte[] bytes = buf.m_130052_();
            Intrinsics.checkNotNullExpressionValue((Object)uuid, (String)"uuid");
            MsgSendEverbookC2S packet = new MsgSendEverbookC2S(new Everbook(uuid, new LinkedHashMap(), CollectionsKt.emptyList()));
            long maxSize = isSingleplayer ? Long.MAX_VALUE : HexalConfig.getServer().getEverbookMaxSize();
            try {
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                CompoundTag decompressed = HexalNBTHelperKt.decompressToNBT(bytes, maxSize);
                HexalAPI.LOGGER.info("Deserializing everbook data of size " + bytes.length + " decompressed to size " + decompressed.m_263179_());
                packet = new MsgSendEverbookC2S(Everbook.Companion.fromNbt(decompressed));
                packet.amountOverLimit = (long)decompressed.m_263179_() - HexalConfig.getServer().getEverbookMaxSize();
            }
            catch (NbtSizeException nbtSizeException) {
                packet.wasTooBig = true;
            }
            catch (Exception e) {
                HexalAPI.LOGGER.error("An unexpected error occurred while attempting to decompress player " + uuid + "'s everbook data.", (Throwable)e);
                packet.somethingWeirdHappened = true;
            }
            return packet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

