/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.wisp;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.casting.eval.env.WispCastEnv;
import ram.talia.hexal.api.casting.mishaps.MishapExcessiveReproduction;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.common.entities.ProjectileWisp;
import ram.talia.hexal.common.entities.TickingWisp;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lram/talia/hexal/common/casting/actions/spells/wisp/OpSummonWisp;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "ticking", "", "(Z)V", "argc", "", "getArgc", "()I", "getTicking", "()Z", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "executeWithUserdata", "userData", "Lnet/minecraft/nbt/CompoundTag;", "Spell", "hexal-forge-1.20.1"})
public final class OpSummonWisp
implements SpellAction {
    private final boolean ticking;
    private final int argc;

    public OpSummonWisp(boolean ticking) {
        this.ticking = ticking;
        this.argc = this.ticking ? 3 : 4;
    }

    public final boolean getTicking() {
        return this.ticking;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        throw new IllegalStateException("OpSummonWisp implements executeWithUserdata, execute shouldn't be called.");
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        Spell spell;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)userData, (String)"userData");
        SpellList hex = OperatorUtils.getList(args, (int)0, (int)this.getArgc());
        Vec3 pos2 = OperatorUtils.getVec3(args, (int)1, (int)this.getArgc());
        double media = 0.0;
        long cost = 0L;
        if (env instanceof WispCastEnv && ((WispCastEnv)env).getWisp().getSummonedChildThisCast()) {
            throw new MishapExcessiveReproduction(((WispCastEnv)env).getWisp());
        }
        Iota ravenmind = userData.m_128441_(HexAPI.RAVENMIND_USERDATA) ? IotaType.deserialize((CompoundTag)userData.m_128469_(HexAPI.RAVENMIND_USERDATA), (ServerLevel)env.getWorld()) : (Iota)new NullIota();
        boolean bl = this.ticking;
        if (bl) {
            media = OperatorUtils.getPositiveDouble(args, (int)2, (int)this.getArgc());
            cost = OperatorUtilsKt.addBounded(HexalConfig.getServer().getSummonTickingWispCost(), (long)(media * (double)10000L));
            spell = new Spell(true, pos2, CollectionsKt.toList((Iterable)((Iterable)hex)), ravenmind, (long)(media * (double)10000L), null, 32, null);
        } else if (!bl) {
            Vec3 vel = OperatorUtils.getVec3(args, (int)2, (int)this.getArgc());
            media = OperatorUtils.getPositiveDouble(args, (int)3, (int)this.getArgc());
            cost = OperatorUtilsKt.addBounded(Math.max((long)((double)HexalConfig.getServer().getSummonProjectileWispCost() * vel.m_82556_()), HexalConfig.getServer().getSummonProjectileWispMinCost()), (long)(media * (double)10000L));
            spell = new Spell(false, pos2, CollectionsKt.toList((Iterable)((Iterable)hex)), ravenmind, (long)(media * (double)10000L), vel);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Spell spell2 = spell;
        env.assertVecInRange(pos2);
        Object[] objectArray = new ParticleSpray[]{ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)pos2, (double)1.5, (int)0, (int)4, null), ParticleSpray.Companion.cloud$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)pos2, (double)0.5, (int)0, (int)4, null)};
        return new SpellAction.Result((RenderedSpell)spell2, cost, CollectionsKt.listOf((Object[])objectArray), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003JM\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010$\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006+"}, d2={"Lram/talia/hexal/common/casting/actions/spells/wisp/OpSummonWisp$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "ticking", "", "pos", "Lnet/minecraft/world/phys/Vec3;", "hex", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "ravenmind", "media", "", "vel", "(ZLnet/minecraft/world/phys/Vec3;Ljava/util/List;Lat/petrak/hexcasting/api/casting/iota/Iota;JLnet/minecraft/world/phys/Vec3;)V", "getHex", "()Ljava/util/List;", "getMedia", "()J", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "getRavenmind", "()Lat/petrak/hexcasting/api/casting/iota/Iota;", "getTicking", "()Z", "getVel", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "", "hexal-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        private final boolean ticking;
        @NotNull
        private final Vec3 pos;
        @NotNull
        private final List<Iota> hex;
        @Nullable
        private final Iota ravenmind;
        private final long media;
        @NotNull
        private final Vec3 vel;

        public Spell(boolean ticking, @NotNull Vec3 pos2, @NotNull List<? extends Iota> hex, @Nullable Iota ravenmind, long media, @NotNull Vec3 vel) {
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
            Intrinsics.checkNotNullParameter(hex, (String)"hex");
            Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
            this.ticking = ticking;
            this.pos = pos2;
            this.hex = hex;
            this.ravenmind = ravenmind;
            this.media = media;
            this.vel = vel;
        }

        public /* synthetic */ Spell(boolean bl, Vec3 vec3, List list, Iota iota, long l, Vec3 vec32, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                Vec3 vec33 = Vec3.f_82478_;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
                vec32 = vec33;
            }
            this(bl, vec3, list, iota, l, vec32);
        }

        public final boolean getTicking() {
            return this.ticking;
        }

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        @NotNull
        public final List<Iota> getHex() {
            return this.hex;
        }

        @Nullable
        public final Iota getRavenmind() {
            return this.ravenmind;
        }

        public final long getMedia() {
            return this.media;
        }

        @NotNull
        public final Vec3 getVel() {
            return this.vel;
        }

        public void cast(@NotNull CastingEnvironment env) {
            BaseCastingWisp baseCastingWisp;
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (env instanceof WispCastEnv) {
                ((WispCastEnv)env).getWisp().setSummonedChildThisCast(true);
            }
            FrozenPigment pigment = env.getPigment();
            boolean bl = this.ticking;
            if (bl) {
                ServerLevel serverLevel = env.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
                var5_4 = env.getCastingEntity();
                baseCastingWisp = new TickingWisp((Level)serverLevel, this.pos, var5_4 instanceof Player ? (Player)var5_4 : null, this.media);
            } else if (!bl) {
                ServerLevel serverLevel = env.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
                var5_4 = env.getCastingEntity();
                baseCastingWisp = new ProjectileWisp((Level)serverLevel, this.pos, this.vel, var5_4 instanceof Player ? (Player)var5_4 : null, this.media);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            BaseCastingWisp wisp = baseCastingWisp;
            Intrinsics.checkNotNullExpressionValue((Object)pigment, (String)"pigment");
            wisp.setPigment(pigment);
            wisp.setHex(CollectionsKt.toMutableList((Collection)this.hex));
            wisp.setRavenmind(this.ravenmind);
            env.getWorld().m_7967_((Entity)wisp);
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        public final boolean component1() {
            return this.ticking;
        }

        @NotNull
        public final Vec3 component2() {
            return this.pos;
        }

        @NotNull
        public final List<Iota> component3() {
            return this.hex;
        }

        @Nullable
        public final Iota component4() {
            return this.ravenmind;
        }

        public final long component5() {
            return this.media;
        }

        @NotNull
        public final Vec3 component6() {
            return this.vel;
        }

        @NotNull
        public final Spell copy(boolean ticking, @NotNull Vec3 pos2, @NotNull List<? extends Iota> hex, @Nullable Iota ravenmind, long media, @NotNull Vec3 vel) {
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
            Intrinsics.checkNotNullParameter(hex, (String)"hex");
            Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
            return new Spell(ticking, pos2, hex, ravenmind, media, vel);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, boolean bl, Vec3 vec3, List list, Iota iota, long l, Vec3 vec32, int n, Object object) {
            if ((n & 1) != 0) {
                bl = spell.ticking;
            }
            if ((n & 2) != 0) {
                vec3 = spell.pos;
            }
            if ((n & 4) != 0) {
                list = spell.hex;
            }
            if ((n & 8) != 0) {
                iota = spell.ravenmind;
            }
            if ((n & 0x10) != 0) {
                l = spell.media;
            }
            if ((n & 0x20) != 0) {
                vec32 = spell.vel;
            }
            return spell.copy(bl, vec3, list, iota, l, vec32);
        }

        @NotNull
        public String toString() {
            return "Spell(ticking=" + this.ticking + ", pos=" + this.pos + ", hex=" + this.hex + ", ravenmind=" + this.ravenmind + ", media=" + this.media + ", vel=" + this.vel + ")";
        }

        public int hashCode() {
            int n = this.ticking ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + this.pos.hashCode();
            result = result * 31 + ((Object)this.hex).hashCode();
            result = result * 31 + (this.ravenmind == null ? 0 : this.ravenmind.hashCode());
            result = result * 31 + Long.hashCode(this.media);
            result = result * 31 + this.vel.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (this.ticking != spell.ticking) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hex, spell.hex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ravenmind, (Object)spell.ravenmind)) {
                return false;
            }
            if (this.media != spell.media) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.vel, (Object)spell.vel);
        }
    }
}

