/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.motes;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.casting.castables.VarargSpellAction;
import ram.talia.hexal.api.casting.eval.env.WispCastEnv;
import ram.talia.hexal.api.casting.iota.MoteIota;
import ram.talia.hexal.api.casting.mishaps.MishapNoBoundStorage;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.mediafieditems.ItemRecord;
import ram.talia.hexal.api.mediafieditems.MediafiedItemManager;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J&\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lram/talia/hexal/common/casting/actions/spells/motes/OpUseMoteOn;", "Lram/talia/hexal/api/casting/castables/VarargSpellAction;", "()V", "argc", "", "stack", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "BlockTargetSpell", "EntityTargetSpell", "hexal-forge-1.20.1"})
public final class OpUseMoteOn
implements VarargSpellAction {
    @NotNull
    public static final OpUseMoteOn INSTANCE = new OpUseMoteOn();

    private OpUseMoteOn() {
    }

    @Override
    public int argc(@NotNull List<? extends Iota> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        return stack.get(0) instanceof EntityIota ? 2 : 3;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, int argc, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        MoteIota item = OperatorUtilsKt.getMote(args, 0, argc);
        if (item == null || item.getCount() != 1L && item.getTag() != null) {
            MoteIota moteIota = item;
            Intrinsics.checkNotNull((Object)((Object)moteIota));
            throw new MishapInvalidIota((Iota)moteIota, 0, (Component)HexUtils.getAsTranslatedComponent((String)"hexcasting.mishap.invalid_value.mote_with_nbt_not_size_one"));
        }
        if (argc == 2) {
            Entity target = OperatorUtils.getEntity(args, (int)1, (int)argc);
            env.assertEntityInRange(target);
            UUID storage = item.getItemIndex().getStorage();
            if (!MediafiedItemManager.isStorageLoaded(storage)) {
                throw new MishapNoBoundStorage("storage_unloaded");
            }
            RenderedSpell renderedSpell = new EntityTargetSpell(target, item);
            long l = HexalConfig.getServer().getUseItemOnCost();
            Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)target.m_20097_()));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(target.onPos)");
            return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec3, (double)1.0, (int)0, (int)4, null)), 0L, 8, null);
        }
        Vec3 direction = OperatorUtils.getVec3(args, (int)2, (int)argc);
        BlockPos target = OperatorUtils.getBlockPos(args, (int)1, (int)argc);
        env.assertPosInRange(target);
        UUID storage = item.getItemIndex().getStorage();
        if (!MediafiedItemManager.isStorageLoaded(storage)) {
            throw new MishapNoBoundStorage("storage_unloaded");
        }
        RenderedSpell renderedSpell = new BlockTargetSpell(target, direction, item);
        long l = HexalConfig.getServer().getUseItemOnCost();
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)new BlockPos((Vec3i)target)));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(BlockPos(target))");
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec3, (double)1.0, (int)0, (int)4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment env) {
        return VarargSpellAction.DefaultImpls.hasCastingSound(this, env);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment env) {
        return VarargSpellAction.DefaultImpls.awardsCastingStat(this, env);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, int argc, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return VarargSpellAction.DefaultImpls.executeWithUserdata(this, args, argc, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return VarargSpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lram/talia/hexal/common/casting/actions/spells/motes/OpUseMoteOn$EntityTargetSpell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "entity", "Lnet/minecraft/world/entity/Entity;", "item", "Lram/talia/hexal/api/casting/iota/MoteIota;", "(Lnet/minecraft/world/entity/Entity;Lram/talia/hexal/api/casting/iota/MoteIota;)V", "getEntity", "()Lnet/minecraft/world/entity/Entity;", "getItem", "()Lram/talia/hexal/api/casting/iota/MoteIota;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexal-forge-1.20.1"})
    private static final class EntityTargetSpell
    implements RenderedSpell {
        @NotNull
        private final Entity entity;
        @NotNull
        private final MoteIota item;

        public EntityTargetSpell(@NotNull Entity entity, @NotNull MoteIota item) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            this.entity = entity;
            this.item = item;
        }

        @NotNull
        public final Entity getEntity() {
            return this.entity;
        }

        @NotNull
        public final MoteIota getItem() {
            return this.item;
        }

        public void cast(@NotNull CastingEnvironment env) {
            ItemRecord itemRecord;
            ServerPlayer caster;
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.isEntityInRange(this.entity)) {
                return;
            }
            ServerPlayer serverPlayer = env.getCaster();
            if (serverPlayer == null) {
                if (env instanceof WispCastEnv) {
                    ServerLevel serverLevel = ((WispCastEnv)env).getWorld();
                    UUID uUID = ((WispCastEnv)env).getWisp().m_20148_();
                    String string = ((WispCastEnv)env).getWisp().m_20148_().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"env.wisp.uuid.toString()");
                    String string2 = string;
                    int n = 0;
                    int n2 = 4;
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    serverPlayer = ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.getFakePlayer(serverLevel, new GameProfile(uUID, "[Wisp " + string3 + "]"));
                } else {
                    serverPlayer = caster = ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.getFakePlayer(env.getWorld(), IXplatAbstractions.HEXCASTING);
                }
            }
            if ((itemRecord = this.item.getRecord()) == null || (itemRecord = itemRecord.toStack(1)) == null) {
                return;
            }
            ItemRecord itemStack2 = itemRecord;
            ItemStack oldStack = caster.m_21120_(env.getCastingHand());
            caster.m_21008_(env.getCastingHand(), (ItemStack)itemStack2);
            this.entity.m_6096_((Player)caster, InteractionHand.MAIN_HAND);
            caster.m_21008_(env.getCastingHand(), oldStack);
            this.item.setTag(itemStack2.m_41783_());
            if (itemStack2.m_41619_()) {
                this.item.removeItems(1);
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final Entity component1() {
            return this.entity;
        }

        @NotNull
        public final MoteIota component2() {
            return this.item;
        }

        @NotNull
        public final EntityTargetSpell copy(@NotNull Entity entity, @NotNull MoteIota item) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            return new EntityTargetSpell(entity, item);
        }

        public static /* synthetic */ EntityTargetSpell copy$default(EntityTargetSpell entityTargetSpell, Entity entity, MoteIota moteIota, int n, Object object) {
            if ((n & 1) != 0) {
                entity = entityTargetSpell.entity;
            }
            if ((n & 2) != 0) {
                moteIota = entityTargetSpell.item;
            }
            return entityTargetSpell.copy(entity, moteIota);
        }

        @NotNull
        public String toString() {
            return "EntityTargetSpell(entity=" + this.entity + ", item=" + this.item + ")";
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + this.item.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityTargetSpell)) {
                return false;
            }
            EntityTargetSpell entityTargetSpell = (EntityTargetSpell)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)entityTargetSpell.entity)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.item), (Object)((Object)entityTargetSpell.item));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lram/talia/hexal/common/casting/actions/spells/motes/OpUseMoteOn$BlockTargetSpell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "direction", "Lnet/minecraft/world/phys/Vec3;", "item", "Lram/talia/hexal/api/casting/iota/MoteIota;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/Vec3;Lram/talia/hexal/api/casting/iota/MoteIota;)V", "getDirection", "()Lnet/minecraft/world/phys/Vec3;", "getItem", "()Lram/talia/hexal/api/casting/iota/MoteIota;", "getPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexal-forge-1.20.1"})
    private static final class BlockTargetSpell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final Vec3 direction;
        @NotNull
        private final MoteIota item;

        public BlockTargetSpell(@NotNull BlockPos pos2, @NotNull Vec3 direction, @NotNull MoteIota item) {
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            this.pos = pos2;
            this.direction = direction;
            this.item = item;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final Vec3 getDirection() {
            return this.direction;
        }

        @NotNull
        public final MoteIota getItem() {
            return this.item;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.canEditBlockAt(this.pos)) {
                return;
            }
            ItemRecord itemRecord = this.item.getRecord();
            if (itemRecord == null || (itemRecord = itemRecord.toStack(1)) == null) {
                return;
            }
            ItemRecord itemStack2 = itemRecord;
            ServerLevel serverLevel = env.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
            UseOnContext context = AccessorWrappers.UseOnContext((Level)((Level)serverLevel), (Player)((Player)env.getCaster()), (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)itemStack2, (BlockHitResult)new BlockHitResult(Vec3.m_82512_((Vec3i)((Vec3i)this.pos)), Direction.m_122366_((double)this.direction.f_82479_, (double)this.direction.f_82480_, (double)this.direction.f_82481_), this.pos, false));
            boolean isAllowed = ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.isPlacingAllowed(env.getWorld(), this.pos, (ItemStack)itemStack2, (Player)env.getCaster());
            if (!isAllowed) {
                return;
            }
            itemStack2.m_41661_(context).m_19077_();
            this.item.setTag(itemStack2.m_41783_());
            if (itemStack2.m_41619_()) {
                this.item.removeItems(1);
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final Vec3 component2() {
            return this.direction;
        }

        @NotNull
        public final MoteIota component3() {
            return this.item;
        }

        @NotNull
        public final BlockTargetSpell copy(@NotNull BlockPos pos2, @NotNull Vec3 direction, @NotNull MoteIota item) {
            Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            return new BlockTargetSpell(pos2, direction, item);
        }

        public static /* synthetic */ BlockTargetSpell copy$default(BlockTargetSpell blockTargetSpell, BlockPos blockPos, Vec3 vec3, MoteIota moteIota, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = blockTargetSpell.pos;
            }
            if ((n & 2) != 0) {
                vec3 = blockTargetSpell.direction;
            }
            if ((n & 4) != 0) {
                moteIota = blockTargetSpell.item;
            }
            return blockTargetSpell.copy(blockPos, vec3, moteIota);
        }

        @NotNull
        public String toString() {
            return "BlockTargetSpell(pos=" + this.pos + ", direction=" + this.direction + ", item=" + this.item + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.direction.hashCode();
            result = result * 31 + this.item.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockTargetSpell)) {
                return false;
            }
            BlockTargetSpell blockTargetSpell = (BlockTargetSpell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)blockTargetSpell.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.direction, (Object)blockTargetSpell.direction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.item), (Object)((Object)blockTargetSpell.item));
        }
    }
}

