/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.link;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.casting.mishaps.MishapLinkToSelf;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lram/talia/hexal/common/casting/actions/spells/link/OpLink;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexal-forge-1.20.1"})
public final class OpLink
implements SpellAction {
    @NotNull
    public static final OpLink INSTANCE = new OpLink();
    private static final int argc = 1;

    private OpLink() {
    }

    public int getArgc() {
        return argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ILinkable linkThis = LinkableRegistry.linkableFromCastingEnvironment(env);
        ServerLevel serverLevel = env.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
        ILinkable iLinkable = LinkableRegistry.linkableFromIota(args.get(0), serverLevel);
        if (iLinkable == null) {
            throw MishapInvalidIota.Companion.ofType(args.get(0), 0, "linkable");
        }
        ILinkable linkOther = iLinkable;
        if (Intrinsics.areEqual((Object)linkThis, (Object)linkOther)) {
            throw new MishapLinkToSelf(linkThis);
        }
        env.assertVecInRange(linkOther.getPosition());
        if (!linkThis.isInRange(linkOther)) {
            throw new MishapBadLocation(linkOther.getPosition(), null, 2, null);
        }
        return new SpellAction.Result((RenderedSpell)new Spell(linkThis, linkOther), HexalConfig.getServer().getLinkCost(), CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)linkOther.getPosition(), (double)1.5, (int)0, (int)4, null)), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lram/talia/hexal/common/casting/actions/spells/link/OpLink$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "linkThis", "Lram/talia/hexal/api/linkable/ILinkable;", "linkOther", "(Lram/talia/hexal/api/linkable/ILinkable;Lram/talia/hexal/api/linkable/ILinkable;)V", "getLinkOther", "()Lram/talia/hexal/api/linkable/ILinkable;", "getLinkThis", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexal-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ILinkable linkThis;
        @NotNull
        private final ILinkable linkOther;

        public Spell(@NotNull ILinkable linkThis, @NotNull ILinkable linkOther) {
            Intrinsics.checkNotNullParameter((Object)linkThis, (String)"linkThis");
            Intrinsics.checkNotNullParameter((Object)linkOther, (String)"linkOther");
            this.linkThis = linkThis;
            this.linkOther = linkOther;
        }

        @NotNull
        public final ILinkable getLinkThis() {
            return this.linkThis;
        }

        @NotNull
        public final ILinkable getLinkOther() {
            return this.linkOther;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ILinkable.DefaultImpls.link$default(this.linkThis, this.linkOther, false, 2, null);
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final ILinkable component1() {
            return this.linkThis;
        }

        @NotNull
        public final ILinkable component2() {
            return this.linkOther;
        }

        @NotNull
        public final Spell copy(@NotNull ILinkable linkThis, @NotNull ILinkable linkOther) {
            Intrinsics.checkNotNullParameter((Object)linkThis, (String)"linkThis");
            Intrinsics.checkNotNullParameter((Object)linkOther, (String)"linkOther");
            return new Spell(linkThis, linkOther);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ILinkable iLinkable, ILinkable iLinkable2, int n, Object object) {
            if ((n & 1) != 0) {
                iLinkable = spell.linkThis;
            }
            if ((n & 2) != 0) {
                iLinkable2 = spell.linkOther;
            }
            return spell.copy(iLinkable, iLinkable2);
        }

        @NotNull
        public String toString() {
            return "Spell(linkThis=" + this.linkThis + ", linkOther=" + this.linkOther + ")";
        }

        public int hashCode() {
            int result = this.linkThis.hashCode();
            result = result * 31 + this.linkOther.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.linkThis, (Object)spell.linkThis)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.linkOther, (Object)spell.linkOther);
        }
    }
}

