/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.gates;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.mod.HexTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.casting.castables.VarargSpellAction;
import ram.talia.hexal.api.casting.iota.GateIota;
import ram.talia.hexal.api.config.HexalConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J&\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001b"}, d2={"Lram/talia/hexal/common/casting/actions/spells/gates/OpCloseGate;", "Lram/talia/hexal/api/casting/castables/VarargSpellAction;", "()V", "aboveStackRoot", "", "toCheck", "Lnet/minecraft/world/entity/Entity;", "allTeleportees", "", "argc", "", "stack", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "recursiveDismount", "", "base", "teleportRespectSticky", "teleportee", "delta", "Lnet/minecraft/world/phys/Vec3;", "Spell", "hexal-forge-1.20.1"})
public final class OpCloseGate
implements VarargSpellAction {
    @NotNull
    public static final OpCloseGate INSTANCE = new OpCloseGate();

    private OpCloseGate() {
    }

    @Override
    public int argc(@NotNull List<? extends Iota> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        if (stack.isEmpty()) {
            return 1;
        }
        Iota top = stack.get(0);
        if (top instanceof GateIota && !((GateIota)top).isDrifting()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, int argc, @NotNull CastingEnvironment env) {
        void $this$mapTo$iv$iv;
        Iterable element$iv2;
        Vec3 vec3;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        GateIota gate = OperatorUtilsKt.getGate(args, 0, argc);
        if (gate.isDrifting()) {
            vec3 = OperatorUtils.getVec3(args, (int)1, (int)argc);
        } else {
            vec3 = gate.getTargetPos(env.getWorld());
            if (vec3 == null) {
                throw new IllegalStateException("non-drifting gates should always have a target pos.");
            }
        }
        Vec3 targetPos = vec3;
        if (gate.isDrifting()) {
            env.assertVecInRange(targetPos);
        }
        if (!env.isVecInWorld(targetPos.m_82492_(0.0, 1.0, 0.0))) {
            throw new MishapBadLocation(targetPos, "too_close_to_out");
        }
        Set<Entity> gatees = gate.getMarked(env.getWorld());
        gate.clearMarked();
        long cost = HexalConfig.getServer().getCloseGateCost();
        if (gate.isDrifting()) {
            void $this$fold$iv;
            Intrinsics.checkNotNullExpressionValue(gatees, (String)"gatees");
            Iterable iterable = gatees;
            long initial$iv = cost;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Iterable element$iv2 : $this$fold$iv) {
                void gatee;
                Entity entity = (Entity)element$iv2;
                long cumCost = accumulator$iv;
                boolean bl = false;
                accumulator$iv = cumCost + (long)((double)HexalConfig.getServer().getCloseGateDistanceCostFactor() * gatee.m_20182_().m_82554_(targetPos));
            }
            cost = accumulator$iv;
        }
        double meanEyeHeight = 0.0;
        Intrinsics.checkNotNullExpressionValue(gatees, (String)"gatees");
        Iterable $this$map$iv = gatees;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            meanEyeHeight += (double)it.m_20192_();
            Vec3 vec32 = it.m_20182_().m_82520_(0.0, (double)it.m_20192_() / 2.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"it.position().add(0.0, it.eyeHeight / 2.0, 0.0)");
            collection.add(ParticleSpray.Companion.cloud$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec32, (double)2.0, (int)0, (int)4, null));
        }
        List burst = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
        Vec3 vec33 = targetPos.m_82520_(0.0, (meanEyeHeight /= (double)burst.size()) / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"targetPos.add(0.0, meanEyeHeight / 2.0, 0.0)");
        burst.add(ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec33, (double)2.0, (int)0, (int)4, null));
        return new SpellAction.Result((RenderedSpell)new Spell(gatees, targetPos, gate.isDrifting()), cost, burst, 0L, 8, null);
    }

    public final void teleportRespectSticky(@NotNull Entity teleportee, @NotNull Set<? extends Entity> allTeleportees, @NotNull Vec3 delta) {
        Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
        Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        this.recursiveDismount(teleportee, allTeleportees);
        if (!this.aboveStackRoot(teleportee, allTeleportees)) {
            Vec3 target = teleportee.m_20182_().m_82549_(delta);
            teleportee.m_8127_();
            teleportee.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
        }
    }

    public final void recursiveDismount(@NotNull Entity base, @NotNull Set<? extends Entity> allTeleportees) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
        boolean sticky = base.m_6095_().m_204039_(HexTags.Entities.STICKY_TELEPORTERS);
        for (Entity passenger : base.m_20197_()) {
            if (passenger.m_6095_().m_204039_(HexTags.Entities.CANNOT_TELEPORT) || !sticky && !allTeleportees.contains(passenger)) {
                passenger.m_8127_();
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)passenger, (String)"passenger");
            this.recursiveDismount(passenger, allTeleportees);
        }
    }

    public final boolean aboveStackRoot(@NotNull Entity toCheck, @NotNull Set<? extends Entity> allTeleportees) {
        Intrinsics.checkNotNullParameter((Object)toCheck, (String)"toCheck");
        Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
        Entity entity = toCheck.m_20202_();
        Entity lowerVehicle = entity != null ? entity.m_20202_() : null;
        boolean vehicleGated = CollectionsKt.contains((Iterable)allTeleportees, (Object)toCheck.m_20202_());
        if (lowerVehicle == null) {
            return vehicleGated;
        }
        return vehicleGated || allTeleportees.contains(lowerVehicle) && lowerVehicle.m_6095_().m_204039_(HexTags.Entities.STICKY_TELEPORTERS);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment env) {
        return VarargSpellAction.DefaultImpls.hasCastingSound(this, env);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment env) {
        return VarargSpellAction.DefaultImpls.awardsCastingStat(this, env);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, int argc, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return VarargSpellAction.DefaultImpls.executeWithUserdata(this, args, argc, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return VarargSpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J-\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J,\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lram/talia/hexal/common/casting/actions/spells/gates/OpCloseGate$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "gatees", "", "Lnet/minecraft/world/entity/Entity;", "targetPos", "Lnet/minecraft/world/phys/Vec3;", "dropItems", "", "(Ljava/util/Set;Lnet/minecraft/world/phys/Vec3;Z)V", "getDropItems", "()Z", "getGatees", "()Ljava/util/Set;", "getTargetPos", "()Lnet/minecraft/world/phys/Vec3;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "teleport", "teleportee", "allTeleportees", "delta", "toString", "", "hexal-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Set<Entity> gatees;
        @NotNull
        private final Vec3 targetPos;
        private final boolean dropItems;

        public Spell(@NotNull Set<? extends Entity> gatees, @NotNull Vec3 targetPos, boolean dropItems) {
            Intrinsics.checkNotNullParameter(gatees, (String)"gatees");
            Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
            this.gatees = gatees;
            this.targetPos = targetPos;
            this.dropItems = dropItems;
        }

        @NotNull
        public final Set<Entity> getGatees() {
            return this.gatees;
        }

        @NotNull
        public final Vec3 getTargetPos() {
            return this.targetPos;
        }

        public final boolean getDropItems() {
            return this.dropItems;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            for (Entity gatee : this.gatees) {
                Vec3 vec3 = gatee.m_20182_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"gatee.position()");
                this.teleport(gatee, this.gatees, OperatorUtilsKt.minus(this.targetPos, vec3), env);
            }
        }

        public final void teleport(@NotNull Entity teleportee, @NotNull Set<? extends Entity> allTeleportees, @NotNull Vec3 delta, @NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            double distance = delta.m_82553_();
            INSTANCE.teleportRespectSticky(teleportee, allTeleportees, delta);
            if (teleportee instanceof ServerPlayer && Intrinsics.areEqual((Object)teleportee, (Object)env.getCaster()) && distance < 32.0 && this.dropItems) {
                double baseDropChance = distance / 10000.0;
                for (ItemStack armorItem : ((ServerPlayer)teleportee).m_150109_().f_35975_) {
                    if (EnchantmentHelper.m_44920_((ItemStack)armorItem) || !(Math.random() < baseDropChance * 0.25)) continue;
                    ((ServerPlayer)teleportee).m_7197_(armorItem.m_41777_(), true, false);
                    armorItem.m_41774_(armorItem.m_41613_());
                }
                Iterator iterator = ((ServerPlayer)teleportee).m_150109_().f_35974_.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    double dropChance;
                    int pos2 = n++;
                    ItemStack invItem = (ItemStack)iterator.next();
                    if (Intrinsics.areEqual((Object)invItem, (Object)((ServerPlayer)teleportee).m_21205_())) continue;
                    double d = dropChance = pos2 < 9 ? baseDropChance * 0.5 : baseDropChance;
                    if (!(Math.random() < dropChance)) continue;
                    ((ServerPlayer)teleportee).m_7197_(invItem.m_41777_(), true, false);
                    invItem.m_41774_(invItem.m_41613_());
                }
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final Set<Entity> component1() {
            return this.gatees;
        }

        @NotNull
        public final Vec3 component2() {
            return this.targetPos;
        }

        public final boolean component3() {
            return this.dropItems;
        }

        @NotNull
        public final Spell copy(@NotNull Set<? extends Entity> gatees, @NotNull Vec3 targetPos, boolean dropItems) {
            Intrinsics.checkNotNullParameter(gatees, (String)"gatees");
            Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
            return new Spell(gatees, targetPos, dropItems);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Set set, Vec3 vec3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                set = spell.gatees;
            }
            if ((n & 2) != 0) {
                vec3 = spell.targetPos;
            }
            if ((n & 4) != 0) {
                bl = spell.dropItems;
            }
            return spell.copy(set, vec3, bl);
        }

        @NotNull
        public String toString() {
            return "Spell(gatees=" + this.gatees + ", targetPos=" + this.targetPos + ", dropItems=" + this.dropItems + ")";
        }

        public int hashCode() {
            int result = ((Object)this.gatees).hashCode();
            result = result * 31 + this.targetPos.hashCode();
            int n = this.dropItems ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual(this.gatees, spell.gatees)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetPos, (Object)spell.targetPos)) {
                return false;
            }
            return this.dropItems == spell.dropItems;
        }
    }
}

