/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.client.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.blocks.entity.BlockEntityMediafiedStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lram/talia/hexal/client/blocks/BlockEntityMediafiedStorageRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage;", "()V", "model", "", "getModel", "()Ljava/lang/Void;", "closingAngleEasing", "", "progress", "closingHeightEasing", "", "openingAngleEasing", "openingHeightEasing", "render", "", "blockEntity", "tickDelta", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "Companion", "hexal-forge-1.20.1"})
public final class BlockEntityMediafiedStorageRenderer
implements BlockEntityRenderer<BlockEntityMediafiedStorage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Void model;
    @NotNull
    private static final ResourceLocation TEXTURE_LOCATION;
    public static final float TEXTURE_SIZE = 64.0f;
    public static final float UPPER_WALL_V = 16.0f;
    public static final float LOWER_WALL_V = 26.0f;
    public static final float BOTTOM_U = 0.0f;
    public static final float BOTTOM_V = 0.0f;
    public static final float TOP_U = 0.0f;
    public static final float TOP_V = 0.0f;
    public static final float CIRCLE_U = 0.0f;
    public static final float CIRCLE_V = 32.0f;
    public static final float CIRCLE_RADIUS = 10.0f;
    public static final float WALL_HEIGHT = 6.0f;
    public static final float SPINS_PER_SECOND = 0.5f;
    public static final double CLOSED_LID_HEIGHT = 4.0;
    public static final float CLOSED_LID_ANGLE = 0.0f;
    public static final double OPEN_LID_HEIGHT = 10.0;
    public static final float OPEN_LID_ANGLE = 90.0f;

    @Nullable
    public final Void getModel() {
        return this.model;
    }

    public void render(@NotNull BlockEntityMediafiedStorage blockEntity, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_LOCATION));
        poseStack.m_85836_();
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f poseMatrix = entry.m_252922_();
        Matrix3f normalMatrix = entry.m_252943_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85837_(0.0, 0.001, 0.0);
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        BlockEntityMediafiedStorageRenderer.render$drawHorizontalQuad(buffer, poseMatrix, light, normalMatrix, 8.0f, 0.0f, 0.0f, -1.0f);
        BlockEntityMediafiedStorageRenderer.render$drawWalls(poseStack, buffer, poseMatrix, light, normalMatrix, 26.0f);
        float animationProgress = Mth.m_14036_((float)(((float)blockEntity.getCurrentAnimation().getProgress() + tickDelta) / (float)20), (float)0.0f, (float)1.0f);
        Triple triple = blockEntity.getCurrentAnimation() instanceof BlockEntityMediafiedStorage.AnimationState.Closing ? new Triple((Object)this.closingHeightEasing(Mth.m_14139_((double)animationProgress, (double)10.0, (double)4.0)), (Object)Float.valueOf(this.closingAngleEasing(Mth.m_14179_((float)animationProgress, (float)90.0f, (float)0.0f))), (Object)Float.valueOf(1.0f - animationProgress)) : new Triple((Object)this.openingHeightEasing(Mth.m_14139_((double)animationProgress, (double)4.0, (double)10.0)), (Object)Float.valueOf(this.openingAngleEasing(Mth.m_14179_((float)animationProgress, (float)0.0f, (float)90.0f))), (Object)Float.valueOf(animationProgress));
        double height = ((Number)triple.component1()).doubleValue();
        float angle = ((Number)triple.component2()).floatValue();
        float circleScale = ((Number)triple.component3()).floatValue();
        if ((double)circleScale > 0.01) {
            Level level = blockEntity.m_58904_();
            float circleTime = (float)((level != null ? level.m_46467_() : 0L) % (long)360) + tickDelta;
            float circleRotation = circleTime * 0.5f * (float)18 % 360.0f;
            poseStack.m_85837_(0.0, 8.0, 0.0);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(circleRotation));
            poseStack.m_85841_(circleScale, circleScale, circleScale);
            BlockEntityMediafiedStorageRenderer.render$drawHorizontalQuad(buffer, poseMatrix, light, normalMatrix, 10.0f, 0.0f, 32.0f, 1.0f);
            poseStack.m_85841_(1.0f / circleScale, 1.0f / circleScale, 1.0f / circleScale);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(circleRotation));
            poseStack.m_85837_(0.0, -8.0, 0.0);
        }
        poseStack.m_85837_(0.0, height, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        BlockEntityMediafiedStorageRenderer.render$drawWalls(poseStack, buffer, poseMatrix, light, normalMatrix, 16.0f);
        poseStack.m_85837_(0.0, 6.0, 0.0);
        BlockEntityMediafiedStorageRenderer.render$drawHorizontalQuad(buffer, poseMatrix, light, normalMatrix, 8.0f, 0.0f, 0.0f, 1.0f);
        poseStack.m_85849_();
    }

    private final double openingHeightEasing(double progress) {
        return progress;
    }

    private final float openingAngleEasing(float progress) {
        return progress;
    }

    private final double closingHeightEasing(double progress) {
        return progress;
    }

    private final float closingAngleEasing(float progress) {
        return progress;
    }

    private static final void render$vertex(VertexConsumer buffer, Matrix4f poseMatrix, int $light, Matrix3f normalMatrix, float x, float y, float z, float normX, float normY, float normZ, float u, float v) {
        buffer.m_252986_(poseMatrix, x, y, z).m_193479_(-1).m_7421_(u / 64.0f, v / 64.0f).m_86008_(OverlayTexture.f_118083_).m_85969_($light).m_252939_(normalMatrix, normX, normY, normZ).m_5752_();
    }

    private static final void render$drawHorizontalQuad(VertexConsumer buffer, Matrix4f poseMatrix, int $light, Matrix3f normalMatrix, float radius, float u, float v, float yNormal) {
        float diameter = radius * (float)2;
        BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, -radius, 0.0f, -radius, 0.0f, yNormal, 0.0f, u, v);
        BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, -radius, 0.0f, radius, 0.0f, yNormal, 0.0f, u, v + diameter);
        BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, radius, 0.0f, radius, 0.0f, yNormal, 0.0f, u + diameter, v + diameter);
        BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, radius, 0.0f, -radius, 0.0f, yNormal, 0.0f, u + diameter, v);
    }

    private static final void render$drawWalls(PoseStack $poseStack, VertexConsumer buffer, Matrix4f poseMatrix, int $light, Matrix3f normalMatrix, float v) {
        int n = 4;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            float uStart = 16.0f * (float)it;
            BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, -8.0f, 6.0f, -8.0f, 0.0f, 0.0f, -1.0f, uStart, v);
            BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, 8.0f, 6.0f, -8.0f, 0.0f, 0.0f, -1.0f, uStart + 16.0f, v);
            BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, 8.0f, 0.0f, -8.0f, 0.0f, 0.0f, -1.0f, uStart + 16.0f, v + 6.0f);
            BlockEntityMediafiedStorageRenderer.render$vertex(buffer, poseMatrix, $light, normalMatrix, -8.0f, 0.0f, -8.0f, 0.0f, 0.0f, -1.0f, uStart, v + 6.0f);
            $poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
    }

    static {
        ResourceLocation resourceLocation = HexalAPI.modLoc("textures/block/mediafied_storage.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"modLoc(\"textures/block/mediafied_storage.png\")");
        TEXTURE_LOCATION = resourceLocation;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lram/talia/hexal/client/blocks/BlockEntityMediafiedStorageRenderer$Companion;", "", "()V", "BOTTOM_U", "", "BOTTOM_V", "CIRCLE_RADIUS", "CIRCLE_U", "CIRCLE_V", "CLOSED_LID_ANGLE", "CLOSED_LID_HEIGHT", "", "LOWER_WALL_V", "OPEN_LID_ANGLE", "OPEN_LID_HEIGHT", "SPINS_PER_SECOND", "TEXTURE_LOCATION", "Lnet/minecraft/resources/ResourceLocation;", "getTEXTURE_LOCATION", "()Lnet/minecraft/resources/ResourceLocation;", "TEXTURE_SIZE", "TOP_U", "TOP_V", "UPPER_WALL_V", "WALL_HEIGHT", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getTEXTURE_LOCATION() {
            return TEXTURE_LOCATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

