/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.nbt;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.nbt.NbtSizeException;
import ram.talia.hexal.api.nbt.SlightlyBetterNbtAccounter;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0005*\u00020\u0004\u001a'\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\t\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\b\u001a\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0014\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t*\u00020\n\u001a\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0017\u0010\u0019\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0007\u00a2\u0006\u0002\b\u001b\u001a\u0017\u0010\u0019\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0007\u00a2\u0006\u0002\b\u001d\u001a\u0017\u0010\u0019\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0007\u00a2\u0006\u0002\b\u001e\u001a\u0017\u0010\u0019\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0007\u00a2\u0006\u0002\b \u001a\u0017\u0010\u0019\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0007\u00a2\u0006\u0002\b!\u001a\u0017\u0010\"\u001a\u00020\n*\b\u0012\u0004\u0012\u00020#0\u001aH\u0007\u00a2\u0006\u0002\b$\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\t*\u00020\n\u00a8\u0006&"}, d2={"createDecompressorStream", "Ljava/io/DataInputStream;", "Ljava/io/InputStream;", "decompressToNBT", "Lnet/minecraft/nbt/CompoundTag;", "", "maxSize", "", "toCompoundTagList", "", "Lnet/minecraft/nbt/ListTag;", "toCompressedBytes", "toEntityList", "T", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/server/level/ServerLevel;", "toIRenderCentreMap", "", "Lram/talia/hexal/api/linkable/ILinkable$IRenderCentre;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "toIntList", "", "toIotaList", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "toNbtList", "", "toNbtListSpellDatum", "Ljava/util/UUID;", "toNbtListUUID", "toNbtListInt", "Lnet/minecraft/nbt/Tag;", "toNbtListTag", "toNbtListEntity", "toSyncTag", "Lram/talia/hexal/api/linkable/ILinkable;", "toSyncTagILinkable", "toUUIDList", "hexal-forge-1.20.1"})
public final class HexalNBTHelperKt {
    @NotNull
    public static final List<Iota> toIotaList(@NotNull ListTag $this$toIotaList, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)$this$toIotaList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ArrayList<Iota> out = new ArrayList<Iota>();
        for (Tag patTag : $this$toIotaList) {
            Intrinsics.checkNotNullExpressionValue((Object)patTag, (String)"patTag");
            CompoundTag tag = NBTHelper.getAsCompound((Tag)patTag);
            out.add(IotaType.deserialize((CompoundTag)tag, (ServerLevel)level));
        }
        return out;
    }

    @JvmName(name="toNbtListSpellDatum")
    @NotNull
    public static final ListTag toNbtListSpellDatum(@NotNull List<? extends Iota> $this$toNbtList) {
        Intrinsics.checkNotNullParameter($this$toNbtList, (String)"<this>");
        ListTag patsTag = new ListTag();
        for (Iota iota : $this$toNbtList) {
            patsTag.add((Object)IotaType.serialize((Iota)iota));
        }
        return patsTag;
    }

    public static final /* synthetic */ <T extends Entity> List<T> toEntityList(ListTag $this$toEntityList, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)$this$toEntityList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        boolean $i$f$toEntityList = false;
        ArrayList<Entity> out = new ArrayList<Entity>();
        for (Tag eTag : $this$toEntityList) {
            UUID uuid = NbtUtils.m_129233_((Tag)eTag);
            Entity entity = level.m_8791_(uuid);
            if (entity == null || !entity.m_6084_()) continue;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(entity instanceof Entity)) continue;
            out.add(entity);
        }
        return out;
    }

    @JvmName(name="toNbtListEntity")
    @NotNull
    public static final ListTag toNbtListEntity(@NotNull List<? extends Entity> $this$toNbtList) {
        Intrinsics.checkNotNullParameter($this$toNbtList, (String)"<this>");
        ListTag listTag = new ListTag();
        for (Entity entity : $this$toNbtList) {
            listTag.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
        }
        return listTag;
    }

    @NotNull
    public static final List<Integer> toIntList(@NotNull ListTag $this$toIntList) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntList, (String)"<this>");
        List out = new ArrayList();
        for (Tag idTag : $this$toIntList) {
            Intrinsics.checkNotNullExpressionValue((Object)idTag, (String)"idTag");
            out.add(NBTHelper.getAsInt((Tag)idTag));
        }
        return out;
    }

    @JvmName(name="toNbtListInt")
    @NotNull
    public static final ListTag toNbtListInt(@NotNull List<Integer> $this$toNbtList) {
        Intrinsics.checkNotNullParameter($this$toNbtList, (String)"<this>");
        ListTag listTag = new ListTag();
        Iterable $this$forEach$iv = $this$toNbtList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            listTag.add((Object)IntTag.m_128679_((int)it));
        }
        return listTag;
    }

    @JvmName(name="toNbtListUUID")
    @NotNull
    public static final ListTag toNbtListUUID(@NotNull List<UUID> $this$toNbtList) {
        Intrinsics.checkNotNullParameter($this$toNbtList, (String)"<this>");
        ListTag listTag = new ListTag();
        Iterable $this$forEach$iv = $this$toNbtList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            listTag.add((Object)NbtUtils.m_129226_((UUID)it));
        }
        return listTag;
    }

    @NotNull
    public static final List<UUID> toUUIDList(@NotNull ListTag $this$toUUIDList) {
        Intrinsics.checkNotNullParameter((Object)$this$toUUIDList, (String)"<this>");
        List uuids = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)$this$toUUIDList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tag it = (Tag)element$iv;
            boolean bl = false;
            UUID uUID = NbtUtils.m_129233_((Tag)it);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"loadUUID(it)");
            uuids.add(uUID);
        }
        return uuids;
    }

    @JvmName(name="toNbtListTag")
    @NotNull
    public static final ListTag toNbtListTag(@NotNull List<? extends Tag> $this$toNbtList) {
        Intrinsics.checkNotNullParameter($this$toNbtList, (String)"<this>");
        ListTag listTag = new ListTag();
        Iterable $this$forEach$iv = $this$toNbtList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tag it = (Tag)element$iv;
            boolean bl = false;
            listTag.add((Object)it);
        }
        return listTag;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CompoundTag> toCompoundTagList(@NotNull ListTag $this$toCompoundTagList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toCompoundTagList, (String)"<this>");
        List tags = new ArrayList();
        tags.addAll((Collection)$this$toCompoundTagList);
        Iterable $this$map$iv = tags;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            collection.add((CompoundTag)it);
        }
        return TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
    }

    @JvmName(name="toSyncTagILinkable")
    @NotNull
    public static final ListTag toSyncTagILinkable(@NotNull List<? extends ILinkable> $this$toSyncTag) {
        Intrinsics.checkNotNullParameter($this$toSyncTag, (String)"<this>");
        ListTag listTag = new ListTag();
        Iterable $this$forEach$iv = $this$toSyncTag;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ILinkable it = (ILinkable)element$iv;
            boolean bl = false;
            listTag.add((Object)LinkableRegistry.wrapSync(it));
        }
        return listTag;
    }

    @NotNull
    public static final Map<CompoundTag, ILinkable.IRenderCentre> toIRenderCentreMap(@NotNull ListTag $this$toIRenderCentreMap, @NotNull ClientLevel level) {
        Intrinsics.checkNotNullParameter((Object)$this$toIRenderCentreMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map out = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)$this$toIRenderCentreMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tag centreTag = (Tag)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)centreTag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            ILinkable.IRenderCentre centre = LinkableRegistry.fromSync((CompoundTag)centreTag, (Level)level);
            if (centre == null) continue;
            out.put(centreTag, centre);
        }
        return out;
    }

    @NotNull
    public static final byte[] toCompressedBytes(@NotNull CompoundTag $this$toCompressedBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toCompressedBytes, (String)"<this>");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NbtIo.m_128947_((CompoundTag)$this$toCompressedBytes, (OutputStream)out);
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CompoundTag decompressToNBT(@NotNull byte[] $this$decompressToNBT, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$decompressToNBT, (String)"<this>");
        try {
            CompoundTag compoundTag;
            Closeable closeable = HexalNBTHelperKt.createDecompressorStream(new ByteArrayInputStream($this$decompressToNBT));
            Throwable throwable = null;
            try {
                DataInputStream it = (DataInputStream)closeable;
                boolean bl = false;
                CompoundTag compoundTag2 = NbtIo.m_128934_((DataInput)it, (NbtAccounter)new SlightlyBetterNbtAccounter(maxSize));
                compoundTag = compoundTag2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"ByteArrayInputStream(thi\u2026btAccounter(maxSize))\n\t\t}");
            return compoundTag;
        }
        catch (NbtSizeException exception) {
            HexalAPI.LOGGER.info("Attempted to decompress byte array larger than " + maxSize + " bytes.");
            throw exception;
        }
        catch (IOException exception) {
            HexalAPI.LOGGER.error("Could not decompress byte array.", (Throwable)exception);
            throw exception;
        }
    }

    @NotNull
    public static final DataInputStream createDecompressorStream(@NotNull InputStream $this$createDecompressorStream) {
        Intrinsics.checkNotNullParameter((Object)$this$createDecompressorStream, (String)"<this>");
        return new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new GZIPInputStream($this$createDecompressorStream)));
    }
}

