/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.mediafieditems;

import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.config.HexalConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nJ\u001c\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J)\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nJ\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0019J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u00100\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lram/talia/hexal/api/mediafieditems/ItemRecord;", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;)V", "item", "Lnet/minecraft/world/item/Item;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "count", "", "(Lnet/minecraft/world/item/Item;Lnet/minecraft/nbt/CompoundTag;J)V", "getCount", "()J", "setCount", "(J)V", "getItem", "()Lnet/minecraft/world/item/Item;", "setItem", "(Lnet/minecraft/world/item/Item;)V", "getTag", "()Lnet/minecraft/nbt/CompoundTag;", "setTag", "(Lnet/minecraft/nbt/CompoundTag;)V", "absorb", "", "other", "", "addCount", "", "toAdd", "addDrops", "amount", "drops", "", "component1", "component2", "component3", "copy", "equals", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "hashCode", "split", "toStack", "toString", "", "typeMatches", "writeToTag", "Companion", "hexal-forge-1.20.1"})
public final class ItemRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Item item;
    @Nullable
    private CompoundTag tag;
    private long count;
    @NotNull
    public static final String TAG_ITEM_ID = "id";
    @NotNull
    public static final String TAG_NBT = "nbt";
    @NotNull
    public static final String TAG_COUNT = "count";

    public ItemRecord(@NotNull Item item, @Nullable CompoundTag tag, long count) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.item = item;
        this.tag = tag;
        this.count = count;
    }

    @NotNull
    public final Item getItem() {
        return this.item;
    }

    public final void setItem(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"<set-?>");
        this.item = item;
    }

    @Nullable
    public final CompoundTag getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable CompoundTag compoundTag) {
        this.tag = compoundTag;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    public ItemRecord(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Item item = stack.m_41720_();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"stack.item");
        this(item, stack.m_41783_(), stack.m_41613_());
    }

    public final boolean typeMatches(@NotNull ItemRecord other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.item, (Object)other.item) && Intrinsics.areEqual((Object)this.tag, (Object)other.tag);
    }

    public final boolean typeMatches(@NotNull ItemStack other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.item, (Object)other.m_41720_()) && Intrinsics.areEqual((Object)this.tag, (Object)other.m_41783_());
    }

    public final void addCount(long toAdd) {
        this.count = OperatorUtilsKt.addBounded(this.count, toAdd);
    }

    public final boolean absorb(@NotNull ItemRecord other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.typeMatches(other)) {
            return false;
        }
        long oldCount = this.count;
        this.addCount(other.count);
        other.addCount(oldCount - this.count);
        return true;
    }

    public final int absorb(@NotNull ItemStack other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.typeMatches(other)) {
            return other.m_41613_();
        }
        long oldCount = this.count;
        this.addCount(other.m_41613_());
        return other.m_41613_() - (int)(this.count - oldCount);
    }

    @NotNull
    public final ItemRecord split(long amount) {
        CompoundTag compoundTag = this.tag;
        ItemRecord splittee = new ItemRecord(this.item, (CompoundTag)(compoundTag != null ? compoundTag.m_6426_() : null), Math.min(this.count, amount));
        this.count -= splittee.count;
        return splittee;
    }

    @NotNull
    public final Component getDisplayName() {
        ItemStack itemStack2 = new ItemStack((ItemLike)this.item);
        itemStack2.m_41751_(this.tag);
        Component component = itemStack2.m_41786_();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"itemStack.hoverName");
        return component;
    }

    @NotNull
    public final ItemStack toStack() {
        return this.toStack(1);
    }

    @NotNull
    public final ItemStack toStack(int count) {
        if (count <= 0) {
            ItemStack itemStack2 = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }
        ItemStack result = new ItemStack((ItemLike)this.item);
        CompoundTag compoundTag = this.tag;
        result.m_41751_((CompoundTag)(compoundTag != null ? compoundTag.m_6426_() : null));
        result.m_41764_(count);
        return result;
    }

    public final void addDrops(long amount, @NotNull List<ItemStack> drops) {
        long leftToTake;
        long taken;
        Intrinsics.checkNotNullParameter(drops, (String)"drops");
        for (leftToTake = Math.min(amount, this.count); leftToTake > 0L; leftToTake -= taken) {
            if (drops.size() > HexalConfig.getServer().getMaxItemsReturned() / 64) {
                HexalAPI.LOGGER.warn("Tried dropping an excessive amount of items, ignoring " + leftToTake + " " + this.item);
                break;
            }
            taken = Math.min(leftToTake, (long)this.item.m_41459_());
            drops.add(this.toStack((int)taken));
        }
        this.count = Math.max(this.count - amount + leftToTake, 0L);
    }

    public final void writeToTag(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128359_(TAG_ITEM_ID, BuiltInRegistries.f_257033_.m_7981_((Object)this.item).toString());
        CompoundTag compoundTag = this.tag;
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            NBTHelper.putCompound((CompoundTag)tag, (String)TAG_NBT, (CompoundTag)it);
        }
        tag.m_128356_(TAG_COUNT, this.count);
    }

    @NotNull
    public final Item component1() {
        return this.item;
    }

    @Nullable
    public final CompoundTag component2() {
        return this.tag;
    }

    public final long component3() {
        return this.count;
    }

    @NotNull
    public final ItemRecord copy(@NotNull Item item, @Nullable CompoundTag tag, long count) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return new ItemRecord(item, tag, count);
    }

    public static /* synthetic */ ItemRecord copy$default(ItemRecord itemRecord, Item item, CompoundTag compoundTag, long l, int n, Object object) {
        if ((n & 1) != 0) {
            item = itemRecord.item;
        }
        if ((n & 2) != 0) {
            compoundTag = itemRecord.tag;
        }
        if ((n & 4) != 0) {
            l = itemRecord.count;
        }
        return itemRecord.copy(item, compoundTag, l);
    }

    @NotNull
    public String toString() {
        return "ItemRecord(item=" + this.item + ", tag=" + this.tag + ", count=" + this.count + ")";
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = result * 31 + (this.tag == null ? 0 : this.tag.hashCode());
        result = result * 31 + Long.hashCode(this.count);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ItemRecord)) {
            return false;
        }
        ItemRecord itemRecord = (ItemRecord)other;
        if (!Intrinsics.areEqual((Object)this.item, (Object)itemRecord.item)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)itemRecord.tag)) {
            return false;
        }
        return this.count == itemRecord.count;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lram/talia/hexal/api/mediafieditems/ItemRecord$Companion;", "", "()V", "TAG_COUNT", "", "TAG_ITEM_ID", "TAG_NBT", "readFromTag", "Lram/talia/hexal/api/mediafieditems/ItemRecord;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ItemRecord readFromTag(@NotNull CompoundTag tag) {
            ItemRecord itemRecord;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            try {
                Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(tag.m_128461_(ItemRecord.TAG_ITEM_ID))).orElseThrow(Companion::readFromTag$lambda$0);
                CompoundTag extraTag = tag.m_128441_(ItemRecord.TAG_NBT) ? tag.m_128469_(ItemRecord.TAG_NBT) : null;
                long count = tag.m_128454_(ItemRecord.TAG_COUNT);
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                itemRecord = new ItemRecord(item, extraTag, count);
            }
            catch (Exception e) {
                HexalAPI.LOGGER.error("Tried to load an invalid item key from NBT: " + tag + ", " + e);
                itemRecord = null;
            }
            return itemRecord;
        }

        private static final IllegalArgumentException readFromTag$lambda$0() {
            return new IllegalArgumentException("Unknown item id.");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

