/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.everbook;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.everbook.Everbook;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0006\u0010\u001d\u001a\u00020\u000eJ$\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lram/talia/hexal/api/everbook/MacroHolder;", "", "everbook", "Lram/talia/hexal/api/everbook/Everbook;", "macros", "", "", "(Lram/talia/hexal/api/everbook/Everbook;Ljava/util/List;)V", "(Lram/talia/hexal/api/everbook/Everbook;)V", "getEverbook", "()Lram/talia/hexal/api/everbook/Everbook;", "", "Lnet/minecraft/nbt/CompoundTag;", "deleteMacro", "", "key", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "extractList", "", "spellListTag", "getKey", "getMacro", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "level", "Lnet/minecraft/server/level/ServerLevel;", "isMacro", "", "parseToPattern", "patternTag", "recalcMacros", "resolveKeys", "unresolvedKeys", "currentKeys", "serialiseToNBT", "Lnet/minecraft/nbt/ListTag;", "setMacro", "hexal-forge-1.20.1"})
public final class MacroHolder {
    @NotNull
    private final Everbook everbook;
    @NotNull
    private final Map<String, List<CompoundTag>> macros;

    public MacroHolder(@NotNull Everbook everbook) {
        Intrinsics.checkNotNullParameter((Object)everbook, (String)"everbook");
        this.everbook = everbook;
        this.macros = new LinkedHashMap();
    }

    @NotNull
    public final Everbook getEverbook() {
        return this.everbook;
    }

    public MacroHolder(@NotNull Everbook everbook, @NotNull List<String> macros) {
        Intrinsics.checkNotNullParameter((Object)everbook, (String)"everbook");
        Intrinsics.checkNotNullParameter(macros, (String)"macros");
        this(everbook);
        Iterable $this$forEach$iv = macros;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.macros.put(it, CollectionsKt.emptyList());
        }
        this.recalcMacros();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Iota> getMacro(@NotNull HexPattern key, @NotNull ServerLevel level) {
        List list;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List<CompoundTag> list2 = this.macros.get(this.getKey(key));
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CompoundTag compoundTag = (CompoundTag)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IotaType.deserialize((CompoundTag)it, (ServerLevel)level));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    public final boolean isMacro(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.macros.containsKey(this.getKey(key));
    }

    public final void setMacro(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.macros.put(this.getKey(key), CollectionsKt.emptyList());
        this.recalcMacros();
    }

    public final void deleteMacro(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.macros.remove(this.getKey(key));
        this.recalcMacros();
    }

    public final void recalcMacros() {
        Collection $this$toTypedArray$iv = this.macros.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        List unresolvedKeys = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        List currentKeys = new ArrayList();
        while (!((Collection)unresolvedKeys).isEmpty()) {
            currentKeys.clear();
            currentKeys.add(unresolvedKeys.get(0));
            unresolvedKeys.remove(0);
            this.resolveKeys(unresolvedKeys, currentKeys);
        }
    }

    private final void resolveKeys(List<String> unresolvedKeys, List<String> currentKeys) {
        int i;
        String key = currentKeys.get(currentKeys.size() - 1);
        List list = this.extractList(this.everbook.getIota$hexal_forge_1_20_1(key));
        if (list == null) {
            MacroHolder it = this;
            boolean bl = false;
            currentKeys.remove(key);
            this.macros.put(key, null);
            return;
        }
        List iotas = list;
        List toSpliceIn = new ArrayList();
        int it = iotas.size();
        for (i = 0; i < it; ++i) {
            List macroResult;
            HexPattern pattern;
            if (this.parseToPattern(iotas.get(i)) == null) continue;
            String possibleKey = this.getKey(pattern);
            if (!this.macros.keySet().contains(possibleKey)) continue;
            if (currentKeys.contains(possibleKey)) {
                HexalAPI.LOGGER.debug("key " + possibleKey + " inside iota list for " + key + " resulted in infinite recursion.");
                currentKeys.remove(key);
                this.macros.put(key, null);
                return;
            }
            if (unresolvedKeys.contains(possibleKey)) {
                currentKeys.add(possibleKey);
                unresolvedKeys.remove(possibleKey);
                this.resolveKeys(unresolvedKeys, currentKeys);
            }
            List<CompoundTag> list2 = this.macros.get(possibleKey);
            List list3 = macroResult = list2 != null ? CollectionsKt.toMutableList((Collection)list2) : null;
            if (macroResult == null) continue;
            ((Collection)toSpliceIn).add(new Pair((Object)i, (Object)macroResult));
        }
        for (i = toSpliceIn.size() - 1; -1 < i; --i) {
            int index = ((Number)((Pair)toSpliceIn.get(i)).getFirst()).intValue();
            List iotasBefore = CollectionsKt.slice(iotas, (IntRange)RangesKt.until((int)0, (int)index));
            List iotasAfter = CollectionsKt.slice(iotas, (IntRange)RangesKt.until((int)(index + 1), (int)iotas.size()));
            iotas = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)iotasBefore, (Iterable)((Iterable)((Pair)toSpliceIn.get(i)).getSecond())), (Iterable)iotasAfter));
        }
        currentKeys.remove(key);
        this.macros.put(key, iotas);
    }

    private final List<CompoundTag> extractList(CompoundTag spellListTag) {
        List<CompoundTag> list;
        if (Intrinsics.areEqual((Object)((IotaType)HexIotaTypes.REGISTRY.m_7745_(new ResourceLocation(spellListTag.m_128461_("hexcasting:type")))), (Object)HexIotaTypes.LIST)) {
            ListTag listTag = spellListTag.m_128437_("hexcasting:data", 10);
            Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"spellListTag.getList(Hex\u2026Tag.TAG_COMPOUND.toInt())");
            list = HexalNBTHelperKt.toCompoundTagList(listTag);
        } else {
            list = null;
        }
        return list;
    }

    private final HexPattern parseToPattern(CompoundTag patternTag) {
        HexPattern hexPattern;
        Set keys = patternTag.m_128431_();
        if (keys.size() != 1) {
            return null;
        }
        if (Intrinsics.areEqual((Object)patternTag.m_128461_("hexcasting:type"), (Object)"pattern")) {
            CompoundTag compoundTag = patternTag.m_128469_("hexcasting:data");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"patternTag.getCompound(HexIotaTypes.KEY_DATA)");
            hexPattern = HexPattern.Companion.fromNBT(compoundTag);
        } else {
            hexPattern = null;
        }
        return hexPattern;
    }

    private final String getKey(HexPattern key) {
        CharSequence charSequence;
        String angles = key.anglesSignature();
        CharSequence charSequence2 = angles;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "empty";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final ListTag serialiseToNBT() {
        ListTag tag = new ListTag();
        Map<String, List<CompoundTag>> $this$forEach$iv = this.macros;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<CompoundTag>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<CompoundTag>> element$iv;
            Map.Entry<String, List<CompoundTag>> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            tag.add((Object)StringTag.m_129297_((String)key));
        }
        return tag;
    }
}

