/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.casting.wisp;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.casting.eval.env.WispCastEnv;
import ram.talia.hexal.api.casting.wisp.WispCastingManager;
import ram.talia.hexal.api.nbt.SerialisedIotaList;
import ram.talia.hexal.common.entities.BaseCastingWisp;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u0019J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lram/talia/hexal/api/casting/wisp/WispCastingManager;", "", "caster", "Lnet/minecraft/server/level/ServerPlayer;", "(Lnet/minecraft/server/level/ServerPlayer;)V", "casterUUID", "Ljava/util/UUID;", "cachedServer", "Lnet/minecraft/server/MinecraftServer;", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;)V", "cachedCaster", "getCaster", "()Lnet/minecraft/server/level/ServerPlayer;", "queue", "Ljava/util/PriorityQueue;", "Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCast;", "server", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "cast", "Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCastResult;", "executeCasts", "", "readFromNbt", "tag", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "scheduleCast", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "priority", "", "hex", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "initialStack", "initialRavenmind", "writeToNbt", "Companion", "WispCast", "WispCastResult", "hexal-forge-1.20.1"})
public final class WispCastingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID casterUUID;
    @Nullable
    private MinecraftServer cachedServer;
    @Nullable
    private ServerPlayer cachedCaster;
    @NotNull
    private final PriorityQueue<WispCast> queue;
    @NotNull
    public static final String TAG_CAST_LIST = "cast_list";
    public static final int WISP_EVALS_PER_TICK = 10;
    @NotNull
    private static List<Function2<WispCastingManager, WispCast, Boolean>> specialHandlers = new ArrayList();

    public WispCastingManager(@NotNull UUID casterUUID, @Nullable MinecraftServer cachedServer) {
        Intrinsics.checkNotNullParameter((Object)casterUUID, (String)"casterUUID");
        this.casterUUID = casterUUID;
        this.cachedServer = cachedServer;
        this.queue = new PriorityQueue();
    }

    public WispCastingManager(@NotNull ServerPlayer caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        UUID uUID = caster.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"caster.uuid");
        this(uUID, caster.f_8924_);
        this.cachedCaster = caster;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ServerPlayer getCaster() {
        MinecraftServer minecraftServer;
        ServerPlayer serverPlayer;
        if (this.cachedCaster != null) {
            ServerPlayer serverPlayer2 = this.cachedCaster;
            Intrinsics.checkNotNull((Object)serverPlayer2);
            if (!serverPlayer2.m_213877_()) {
                ServerPlayer serverPlayer3 = this.cachedCaster;
                Intrinsics.checkNotNull((Object)serverPlayer3);
                if (!serverPlayer3.m_21224_()) {
                    serverPlayer = this.cachedCaster;
                    return serverPlayer;
                }
            }
        }
        serverPlayer = this.cachedCaster = (minecraftServer = this.getServer()) != null && (minecraftServer = minecraftServer.m_6846_()) != null ? minecraftServer.m_11259_(this.casterUUID) : null;
        return serverPlayer;
    }

    private final MinecraftServer getServer() {
        Object object = this.cachedServer;
        if (object == null) {
            ServerPlayer serverPlayer = this.cachedCaster;
            object = serverPlayer != null ? serverPlayer.f_8924_ : null;
        }
        return object;
    }

    public final void scheduleCast(@NotNull BaseCastingWisp wisp, int priority, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @Nullable CompoundTag initialRavenmind) {
        boolean bl;
        WispCast cast2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            if (this.getCaster() == null) {
                return;
            }
            ServerPlayer serverPlayer = this.getCaster();
            Intrinsics.checkNotNull((Object)serverPlayer);
            cast2 = new WispCast(wisp, priority, serverPlayer.m_9236_().m_46467_(), hex, initialStack, initialRavenmind);
            Iterable $this$any$iv = specialHandlers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function2 handler = (Function2)element$iv;
                    boolean bl2 = false;
                    Object object = handler.invoke((Object)this, (Object)cast2);
                    boolean it = (Boolean)object;
                    boolean bl3 = false;
                    if (it) {
                        this.cast(cast2).callback();
                    }
                    if (!((Boolean)object).booleanValue()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.queue.add(cast2);
    }

    public final void executeCasts() {
        block9: {
            block8: {
                if (this.getCaster() == null) break block8;
                ServerPlayer serverPlayer = this.getCaster();
                Intrinsics.checkNotNull((Object)serverPlayer);
                if (serverPlayer.f_19797_ > 1) break block9;
            }
            return;
        }
        ServerPlayer serverPlayer = this.getCaster();
        Intrinsics.checkNotNull((Object)serverPlayer);
        if (serverPlayer.m_9236_().f_46443_) {
            HexalAPI.LOGGER.info("HOW DID THIS HAPPEN");
            return;
        }
        int evalsLeft = 10;
        Iterator<WispCast> iterator = this.queue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"queue.iterator()");
        Iterator<WispCast> itr = iterator;
        ArrayList results2 = new ArrayList();
        while (evalsLeft > 0 && itr.hasNext()) {
            ServerPlayer serverPlayer2;
            WispCast cast2 = itr.next();
            itr.remove();
            BaseCastingWisp baseCastingWisp = cast2.getWisp();
            if (baseCastingWisp == null) {
                ServerPlayer serverPlayer3 = this.getCaster();
                Intrinsics.checkNotNull((Object)serverPlayer3);
                Entity entity = serverPlayer3.m_284548_().m_8791_(cast2.getWispUUID());
                baseCastingWisp = entity instanceof BaseCastingWisp ? (BaseCastingWisp)entity : null;
                if (baseCastingWisp == null) continue;
            }
            BaseCastingWisp wisp = baseCastingWisp;
            cast2.setWisp(wisp);
            if (wisp.m_213877_()) continue;
            if (!Intrinsics.areEqual((Object)wisp.m_9236_().m_46472_(), (serverPlayer2 = this.getCaster()) != null && (serverPlayer2 = serverPlayer2.m_9236_()) != null ? serverPlayer2.m_46472_() : null)) {
                wisp.castCallback(new WispCastResult(wisp, false, new ArrayList(), new CompoundTag(), true));
                continue;
            }
            Collection collection = results2;
            Intrinsics.checkNotNullExpressionValue((Object)cast2, (String)"cast");
            collection.add(this.cast(cast2));
            --evalsLeft;
        }
        Iterable $this$forEach$iv = results2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WispCastResult result = (WispCastResult)element$iv;
            boolean bl = false;
            result.callback();
        }
    }

    @NotNull
    public final WispCastResult cast(@NotNull WispCast cast2) {
        Intrinsics.checkNotNullParameter((Object)cast2, (String)"cast");
        BaseCastingWisp baseCastingWisp = cast2.getWisp();
        Intrinsics.checkNotNull((Object)baseCastingWisp);
        BaseCastingWisp wisp = baseCastingWisp;
        wisp.setSummonedChildThisCast(false);
        Level level = wisp.m_9236_();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        WispCastEnv ctx = new WispCastEnv(wisp, (ServerLevel)level);
        CompoundTag userData = new CompoundTag();
        CompoundTag compoundTag = cast2.getInitialRavenmind();
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            String string = HexAPI.RAVENMIND_USERDATA;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RAVENMIND_USERDATA");
            NBTHelper.putCompound((CompoundTag)userData, (String)string, (CompoundTag)it);
        }
        CastingImage castingImage = new CastingImage();
        SerialisedIotaList serialisedIotaList = cast2.getInitialStack();
        ServerLevel serverLevel = ctx.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"ctx.world");
        CastingImage image = CastingImage.copy$default((CastingImage)castingImage, serialisedIotaList.getIotas(serverLevel), (int)0, null, (boolean)false, (long)0L, (CompoundTag)userData, (int)30, null);
        CastingVM harness = new CastingVM(image, (CastingEnvironment)ctx);
        SerialisedIotaList serialisedIotaList2 = cast2.getHex();
        ServerLevel serverLevel2 = ctx.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"ctx.world");
        List<Iota> list = serialisedIotaList2.getIotas(serverLevel2);
        Level level2 = wisp.m_9236_();
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ExecutionClientView info = harness.queueExecuteAndWrapIotas(list, (ServerLevel)level2);
        List endStack = harness.getImage().getStack();
        if (IotaType.isTooLargeToSerialize((Iterable)endStack)) {
            endStack = new ArrayList();
        }
        CompoundTag endRavenmind = harness.getImage().getUserData().m_128469_(HexAPI.RAVENMIND_USERDATA);
        boolean bl = info.getResolutionType().getSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)endRavenmind, (String)"endRavenmind");
        return new WispCastResult(wisp, bl, endStack, endRavenmind, false, 16, null);
    }

    public final void readFromNbt(@Nullable CompoundTag tag, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CompoundTag compoundTag = tag;
        Tag tag2 = compoundTag != null ? compoundTag.m_128423_(TAG_CAST_LIST) : null;
        ListTag listTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
        if (listTag == null) {
            return;
        }
        ListTag list = listTag;
        for (Tag castTag : list) {
            Intrinsics.checkNotNullExpressionValue((Object)castTag, (String)"castTag");
            this.queue.add(WispCast.Companion.makeFromNbt(NBTHelper.getAsCompound((Tag)castTag), level));
        }
    }

    public final void writeToNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ListTag list = new ListTag();
        for (WispCast cast2 : this.queue) {
            list.add((Object)cast2.writeToNbt());
        }
        tag.m_128365_(TAG_CAST_LIST, (Tag)list);
    }

    static {
        specialHandlers.add(Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00010B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rB7\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\t\u0010\"\u001a\u00020\u000fH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\fH\u00c6\u0003JG\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010!\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u0006\u0010/\u001a\u00020\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCast;", "", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "priority", "", "timeAdded", "", "hex", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "initialStack", "initialRavenmind", "Lnet/minecraft/nbt/CompoundTag;", "(Lram/talia/hexal/common/entities/BaseCastingWisp;IJLram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIotaList;Lnet/minecraft/nbt/CompoundTag;)V", "wispUUID", "Ljava/util/UUID;", "(Ljava/util/UUID;IJLram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIotaList;Lnet/minecraft/nbt/CompoundTag;)V", "getHex", "()Lram/talia/hexal/api/nbt/SerialisedIotaList;", "getInitialRavenmind", "()Lnet/minecraft/nbt/CompoundTag;", "getInitialStack", "getPriority", "()I", "getTimeAdded", "()J", "getWisp", "()Lram/talia/hexal/common/entities/BaseCastingWisp;", "setWisp", "(Lram/talia/hexal/common/entities/BaseCastingWisp;)V", "getWispUUID", "()Ljava/util/UUID;", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "", "hashCode", "toString", "", "writeToNbt", "Companion", "hexal-forge-1.20.1"})
    public static final class WispCast
    implements Comparable<WispCast> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UUID wispUUID;
        private final int priority;
        private final long timeAdded;
        @NotNull
        private final SerialisedIotaList hex;
        @NotNull
        private final SerialisedIotaList initialStack;
        @Nullable
        private final CompoundTag initialRavenmind;
        @Nullable
        private BaseCastingWisp wisp;
        @NotNull
        public static final String TAG_WISP = "wisp";
        @NotNull
        public static final String TAG_PRIORITY = "priority";
        @NotNull
        public static final String TAG_TIME_ADDED = "time_added";
        @NotNull
        public static final String TAG_HEX = "hex";
        @NotNull
        public static final String TAG_INITIAL_STACK = "initial_stack";
        @NotNull
        public static final String TAG_INITIAL_RAVENMIND = "initial_ravenmind";

        public WispCast(@NotNull UUID wispUUID, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @Nullable CompoundTag initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wispUUID, (String)"wispUUID");
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            this.wispUUID = wispUUID;
            this.priority = priority;
            this.timeAdded = timeAdded;
            this.hex = hex;
            this.initialStack = initialStack;
            this.initialRavenmind = initialRavenmind;
        }

        @NotNull
        public final UUID getWispUUID() {
            return this.wispUUID;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        @NotNull
        public final SerialisedIotaList getHex() {
            return this.hex;
        }

        @NotNull
        public final SerialisedIotaList getInitialStack() {
            return this.initialStack;
        }

        @Nullable
        public final CompoundTag getInitialRavenmind() {
            return this.initialRavenmind;
        }

        @Nullable
        public final BaseCastingWisp getWisp() {
            return this.wisp;
        }

        public final void setWisp(@Nullable BaseCastingWisp baseCastingWisp) {
            this.wisp = baseCastingWisp;
        }

        public WispCast(@NotNull BaseCastingWisp wisp, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @Nullable CompoundTag initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)TAG_WISP);
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            UUID uUID = wisp.m_20148_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"wisp.uuid");
            this(uUID, priority, timeAdded, hex, initialStack, initialRavenmind);
            this.wisp = wisp;
        }

        @Override
        public int compareTo(@NotNull WispCast other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.priority != other.priority) {
                return this.priority - other.priority;
            }
            return (int)(this.timeAdded - other.timeAdded);
        }

        @NotNull
        public final CompoundTag writeToNbt() {
            CompoundTag tag;
            block0: {
                tag = new CompoundTag();
                tag.m_128362_(TAG_WISP, this.wispUUID);
                tag.m_128405_(TAG_PRIORITY, this.priority);
                tag.m_128356_(TAG_TIME_ADDED, this.timeAdded);
                tag.m_128365_(TAG_HEX, (Tag)this.hex.getTag());
                tag.m_128365_(TAG_INITIAL_STACK, (Tag)this.initialStack.getTag());
                CompoundTag compoundTag = this.initialRavenmind;
                if (compoundTag == null) break block0;
                CompoundTag it = compoundTag;
                boolean bl = false;
                NBTHelper.putCompound((CompoundTag)tag, (String)TAG_INITIAL_RAVENMIND, (CompoundTag)it);
            }
            return tag;
        }

        @NotNull
        public final UUID component1() {
            return this.wispUUID;
        }

        public final int component2() {
            return this.priority;
        }

        public final long component3() {
            return this.timeAdded;
        }

        @NotNull
        public final SerialisedIotaList component4() {
            return this.hex;
        }

        @NotNull
        public final SerialisedIotaList component5() {
            return this.initialStack;
        }

        @Nullable
        public final CompoundTag component6() {
            return this.initialRavenmind;
        }

        @NotNull
        public final WispCast copy(@NotNull UUID wispUUID, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @Nullable CompoundTag initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wispUUID, (String)"wispUUID");
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            return new WispCast(wispUUID, priority, timeAdded, hex, initialStack, initialRavenmind);
        }

        public static /* synthetic */ WispCast copy$default(WispCast wispCast, UUID uUID, int n, long l, SerialisedIotaList serialisedIotaList, SerialisedIotaList serialisedIotaList2, CompoundTag compoundTag, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = wispCast.wispUUID;
            }
            if ((n2 & 2) != 0) {
                n = wispCast.priority;
            }
            if ((n2 & 4) != 0) {
                l = wispCast.timeAdded;
            }
            if ((n2 & 8) != 0) {
                serialisedIotaList = wispCast.hex;
            }
            if ((n2 & 0x10) != 0) {
                serialisedIotaList2 = wispCast.initialStack;
            }
            if ((n2 & 0x20) != 0) {
                compoundTag = wispCast.initialRavenmind;
            }
            return wispCast.copy(uUID, n, l, serialisedIotaList, serialisedIotaList2, compoundTag);
        }

        @NotNull
        public String toString() {
            return "WispCast(wispUUID=" + this.wispUUID + ", priority=" + this.priority + ", timeAdded=" + this.timeAdded + ", hex=" + this.hex + ", initialStack=" + this.initialStack + ", initialRavenmind=" + this.initialRavenmind + ")";
        }

        public int hashCode() {
            int result = this.wispUUID.hashCode();
            result = result * 31 + Integer.hashCode(this.priority);
            result = result * 31 + Long.hashCode(this.timeAdded);
            result = result * 31 + this.hex.hashCode();
            result = result * 31 + this.initialStack.hashCode();
            result = result * 31 + (this.initialRavenmind == null ? 0 : this.initialRavenmind.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WispCast)) {
                return false;
            }
            WispCast wispCast = (WispCast)other;
            if (!Intrinsics.areEqual((Object)this.wispUUID, (Object)wispCast.wispUUID)) {
                return false;
            }
            if (this.priority != wispCast.priority) {
                return false;
            }
            if (this.timeAdded != wispCast.timeAdded) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hex, (Object)wispCast.hex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialStack, (Object)wispCast.initialStack)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialRavenmind, (Object)wispCast.initialRavenmind);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCast$Companion;", "", "()V", "TAG_HEX", "", "TAG_INITIAL_RAVENMIND", "TAG_INITIAL_STACK", "TAG_PRIORITY", "TAG_TIME_ADDED", "TAG_WISP", "makeFromNbt", "Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCast;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "hexal-forge-1.20.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final WispCast makeFromNbt(@NotNull CompoundTag tag, @NotNull ServerLevel level) {
                BaseCastingWisp wisp;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                UUID wispUUID = tag.m_128342_(WispCast.TAG_WISP);
                Entity entity = level.m_8791_(wispUUID);
                BaseCastingWisp baseCastingWisp = wisp = entity instanceof BaseCastingWisp ? (BaseCastingWisp)entity : null;
                if (wisp != null) {
                    entity = tag.m_128423_(WispCast.TAG_HEX);
                    SerialisedIotaList serialisedIotaList = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                    entity = tag.m_128423_(WispCast.TAG_INITIAL_STACK);
                    return new WispCast(wisp, tag.m_128451_(WispCast.TAG_PRIORITY), tag.m_128454_(WispCast.TAG_TIME_ADDED), serialisedIotaList, new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null), tag.m_128441_(WispCast.TAG_INITIAL_RAVENMIND) ? tag.m_128469_(WispCast.TAG_INITIAL_RAVENMIND) : null);
                }
                UUID uUID = tag.m_128342_(WispCast.TAG_WISP);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"tag.getUUID(TAG_WISP)");
                entity = tag.m_128423_(WispCast.TAG_HEX);
                SerialisedIotaList serialisedIotaList = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                entity = tag.m_128423_(WispCast.TAG_INITIAL_STACK);
                return new WispCast(uUID, tag.m_128451_(WispCast.TAG_PRIORITY), tag.m_128454_(WispCast.TAG_TIME_ADDED), serialisedIotaList, new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null), tag.m_128441_(WispCast.TAG_INITIAL_RAVENMIND) ? tag.m_128469_(WispCast.TAG_INITIAL_RAVENMIND) : null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCastResult;", "", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "succeeded", "", "endStack", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "endRavenmind", "Lnet/minecraft/nbt/CompoundTag;", "cancelled", "(Lram/talia/hexal/common/entities/BaseCastingWisp;ZLjava/util/List;Lnet/minecraft/nbt/CompoundTag;Z)V", "getCancelled", "()Z", "getEndRavenmind", "()Lnet/minecraft/nbt/CompoundTag;", "getEndStack", "()Ljava/util/List;", "getSucceeded", "getWisp", "()Lram/talia/hexal/common/entities/BaseCastingWisp;", "callback", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "hexal-forge-1.20.1"})
    public static final class WispCastResult {
        @NotNull
        private final BaseCastingWisp wisp;
        private final boolean succeeded;
        @NotNull
        private final List<Iota> endStack;
        @NotNull
        private final CompoundTag endRavenmind;
        private final boolean cancelled;

        public WispCastResult(@NotNull BaseCastingWisp wisp, boolean succeeded, @NotNull List<? extends Iota> endStack, @NotNull CompoundTag endRavenmind, boolean cancelled) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter(endStack, (String)"endStack");
            Intrinsics.checkNotNullParameter((Object)endRavenmind, (String)"endRavenmind");
            this.wisp = wisp;
            this.succeeded = succeeded;
            this.endStack = endStack;
            this.endRavenmind = endRavenmind;
            this.cancelled = cancelled;
        }

        public /* synthetic */ WispCastResult(BaseCastingWisp baseCastingWisp, boolean bl, List list, CompoundTag compoundTag, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(baseCastingWisp, bl, list, compoundTag, bl2);
        }

        @NotNull
        public final BaseCastingWisp getWisp() {
            return this.wisp;
        }

        public final boolean getSucceeded() {
            return this.succeeded;
        }

        @NotNull
        public final List<Iota> getEndStack() {
            return this.endStack;
        }

        @NotNull
        public final CompoundTag getEndRavenmind() {
            return this.endRavenmind;
        }

        public final boolean getCancelled() {
            return this.cancelled;
        }

        public final void callback() {
            this.wisp.castCallback(this);
        }

        @NotNull
        public final BaseCastingWisp component1() {
            return this.wisp;
        }

        public final boolean component2() {
            return this.succeeded;
        }

        @NotNull
        public final List<Iota> component3() {
            return this.endStack;
        }

        @NotNull
        public final CompoundTag component4() {
            return this.endRavenmind;
        }

        public final boolean component5() {
            return this.cancelled;
        }

        @NotNull
        public final WispCastResult copy(@NotNull BaseCastingWisp wisp, boolean succeeded, @NotNull List<? extends Iota> endStack, @NotNull CompoundTag endRavenmind, boolean cancelled) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter(endStack, (String)"endStack");
            Intrinsics.checkNotNullParameter((Object)endRavenmind, (String)"endRavenmind");
            return new WispCastResult(wisp, succeeded, endStack, endRavenmind, cancelled);
        }

        public static /* synthetic */ WispCastResult copy$default(WispCastResult wispCastResult, BaseCastingWisp baseCastingWisp, boolean bl, List list, CompoundTag compoundTag, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                baseCastingWisp = wispCastResult.wisp;
            }
            if ((n & 2) != 0) {
                bl = wispCastResult.succeeded;
            }
            if ((n & 4) != 0) {
                list = wispCastResult.endStack;
            }
            if ((n & 8) != 0) {
                compoundTag = wispCastResult.endRavenmind;
            }
            if ((n & 0x10) != 0) {
                bl2 = wispCastResult.cancelled;
            }
            return wispCastResult.copy(baseCastingWisp, bl, list, compoundTag, bl2);
        }

        @NotNull
        public String toString() {
            return "WispCastResult(wisp=" + this.wisp + ", succeeded=" + this.succeeded + ", endStack=" + this.endStack + ", endRavenmind=" + this.endRavenmind + ", cancelled=" + this.cancelled + ")";
        }

        public int hashCode() {
            int result = this.wisp.hashCode();
            int n = this.succeeded ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.endStack).hashCode();
            result = result * 31 + this.endRavenmind.hashCode();
            int n2 = this.cancelled ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WispCastResult)) {
                return false;
            }
            WispCastResult wispCastResult = (WispCastResult)other;
            if (!Intrinsics.areEqual((Object)this.wisp, (Object)wispCastResult.wisp)) {
                return false;
            }
            if (this.succeeded != wispCastResult.succeeded) {
                return false;
            }
            if (!Intrinsics.areEqual(this.endStack, wispCastResult.endStack)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endRavenmind, (Object)wispCastResult.endRavenmind)) {
                return false;
            }
            return this.cancelled == wispCastResult.cancelled;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lram/talia/hexal/api/casting/wisp/WispCastingManager$Companion;", "", "()V", "TAG_CAST_LIST", "", "WISP_EVALS_PER_TICK", "", "specialHandlers", "", "Lkotlin/Function2;", "Lram/talia/hexal/api/casting/wisp/WispCastingManager;", "Lram/talia/hexal/api/casting/wisp/WispCastingManager$WispCast;", "", "getSpecialHandlers", "()Ljava/util/List;", "setSpecialHandlers", "(Ljava/util/List;)V", "hexal-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Function2<WispCastingManager, WispCast, Boolean>> getSpecialHandlers() {
            return specialHandlers;
        }

        public final void setSpecialHandlers(@NotNull List<Function2<WispCastingManager, WispCast, Boolean>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            specialHandlers = list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

