/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.gates.GateManager;
import ram.talia.hexal.common.lib.hex.HexalIotaTypes;

public class GateIota
extends Iota {
    public static String TAG_INDEX = "index";
    public static String TAG_TARGET_TYPE = "target_type";
    public static String TAG_TARGET_X = "target_x";
    public static String TAG_TARGET_Y = "target_y";
    public static String TAG_TARGET_Z = "target_z";
    public static String TAG_TARGET_UUID = "target_uuid";
    public static String TAG_TARGET_NAME = "target_name";
    public static IotaType<GateIota> TYPE = new IotaType<GateIota>(){

        private GateIota deserialize(Tag tag) throws IllegalArgumentException {
            if (tag.m_6458_() == IntTag.f_128670_) {
                IntTag itag = (IntTag)tag;
                return new GateIota(itag.m_7047_(), null);
            }
            CompoundTag ctag = (CompoundTag)HexUtils.downcast((Tag)tag, (TagType)CompoundTag.f_128326_);
            int index = ctag.m_128451_(TAG_INDEX);
            byte type2 = ctag.m_128445_(TAG_TARGET_TYPE);
            if (type2 == 0) {
                return new GateIota(index, null);
            }
            double x = ctag.m_128459_(TAG_TARGET_X);
            double y = ctag.m_128459_(TAG_TARGET_Y);
            double z = ctag.m_128459_(TAG_TARGET_Z);
            Vec3 vec = new Vec3(x, y, z);
            if (type2 == 1) {
                return new GateIota(index, (Either<Vec3, Pair<Entity, Vec3>>)Either.left((Object)vec));
            }
            UUID uuid = ctag.m_128342_(TAG_TARGET_UUID);
            String name = ctag.m_128461_(TAG_TARGET_NAME);
            return new GateIota(new Payload(index, (Either<Vec3, EntityAnchor>)Either.right((Object)new EntityAnchor(uuid, name, vec))));
        }

        public GateIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            return this.deserialize(tag);
        }

        public Component display(Tag tag) {
            if (!(tag instanceof IntTag) && !(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            GateIota gate = this.deserialize(tag);
            if (gate.isDrifting()) {
                return Component.m_237110_((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).m_130940_(ChatFormatting.LIGHT_PURPLE);
            }
            return (Component)gate.getTarget().map(vec3 -> Component.m_237110_((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).m_130946_(String.format(" (%.2f, %.2f, %.2f)", vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)).m_130940_(ChatFormatting.LIGHT_PURPLE), entityAnchor -> {
                String offsetStr = String.format("%.2f, %.2f, %.2f", entityAnchor.offset.f_82479_, entityAnchor.offset.f_82480_, entityAnchor.offset.f_82481_);
                String anchorStr = String.format(" (%s, %s)", entityAnchor.name, offsetStr);
                return Component.m_237110_((String)"hexal.spelldata.gate", (Object[])new Object[]{gate.getGateIndex()}).m_130946_(anchorStr).m_130940_(ChatFormatting.LIGHT_PURPLE);
            });
        }

        public int color() {
            return -43521;
        }
    };

    public GateIota(int index, @Nullable Either<Vec3, Pair<Entity, Vec3>> target) {
        super(HexalIotaTypes.GATE, (Object)new Payload(index, target == null ? null : target.mapRight(pair -> new EntityAnchor(((Entity)pair.getFirst()).m_20148_(), ((Entity)pair.getFirst()).m_7755_().getString(), (Vec3)pair.getSecond()))));
    }

    private GateIota(Payload payload) {
        super(HexalIotaTypes.GATE, (Object)payload);
    }

    public int getGateIndex() {
        return ((Payload)this.payload).index;
    }

    @Nullable
    public Either<Vec3, EntityAnchor> getTarget() {
        return ((Payload)this.payload).target;
    }

    @Nullable
    public Vec3 getTargetPos(ServerLevel level) {
        Either<Vec3, EntityAnchor> target = this.getTarget();
        if (target == null) {
            return null;
        }
        return (Vec3)target.map(vec3 -> vec3, entityAnchor -> {
            Entity entity = level.m_8791_(entityAnchor.uuid);
            if (entity == null) {
                return null;
            }
            return entity.m_20182_().m_82549_(entityAnchor.offset);
        });
    }

    public boolean isDrifting() {
        return this.getTarget() == null;
    }

    public boolean isLocationAnchored() {
        Either<Vec3, EntityAnchor> target = this.getTarget();
        return target != null && target.left().isPresent();
    }

    public boolean isEntityAnchored() {
        Either<Vec3, EntityAnchor> target = this.getTarget();
        return target != null && target.right().isPresent();
    }

    public Set<Entity> getMarked(ServerLevel level) {
        Set marked = GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet());
        HashSet<Entity> out = new HashSet<Entity>();
        for (UUID mark : marked) {
            Entity markEntity = level.m_8791_(mark);
            if (markEntity == null) continue;
            out.add(markEntity);
        }
        return out;
    }

    public boolean isMarked(Entity entity) {
        Set marked = GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet());
        return marked.contains(entity.m_20148_());
    }

    public int getNumMarked() {
        return ((Set)GateManager.allMarked.getOrDefault(this.getGateIndex(), new HashSet())).size();
    }

    public void mark(Entity entity) {
        GateManager.mark(this.getGateIndex(), entity);
    }

    public void unmark(@NotNull Entity entity) {
        GateManager.unmark(this.getGateIndex(), entity);
    }

    public void clearMarked() {
        GateManager.clearMarked(this.getGateIndex());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (!GateIota.typesMatch((Iota)this, (Iota)that)) return false;
        if (!(that instanceof GateIota)) return false;
        GateIota gthat = (GateIota)that;
        if (this.getGateIndex() != gthat.getGateIndex()) return false;
        return true;
    }

    public boolean isTruthy() {
        return true;
    }

    @NotNull
    public Tag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(TAG_INDEX, this.getGateIndex());
        if (this.getTarget() == null) {
            tag.m_128344_(TAG_TARGET_TYPE, (byte)0);
        } else {
            tag.m_128344_(TAG_TARGET_TYPE, ((Integer)this.getTarget().map(vec3 -> 1, pair -> 2)).byteValue());
            tag.m_128347_(TAG_TARGET_X, ((Double)this.getTarget().map(vec3 -> vec3.f_82479_, entityAnchor -> entityAnchor.offset.f_82479_)).doubleValue());
            tag.m_128347_(TAG_TARGET_Y, ((Double)this.getTarget().map(vec3 -> vec3.f_82480_, entityAnchor -> entityAnchor.offset.f_82480_)).doubleValue());
            tag.m_128347_(TAG_TARGET_Z, ((Double)this.getTarget().map(vec3 -> vec3.f_82481_, entityAnchor -> entityAnchor.offset.f_82481_)).doubleValue());
            this.getTarget().ifRight(entityAnchor -> {
                tag.m_128362_(TAG_TARGET_UUID, entityAnchor.uuid);
                tag.m_128359_(TAG_TARGET_NAME, entityAnchor.name);
            });
        }
        return tag;
    }

    private record Payload(int index, Either<Vec3, EntityAnchor> target) {
    }

    public record EntityAnchor(UUID uuid, String name, Vec3 offset) {
    }
}

