/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.casting.eval.env.WispMishapEnv;
import ram.talia.hexal.common.entities.BaseCastingWisp;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0015H\u0016J(\u0010/\u001a\u00020\r2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001a012\u0006\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u0004\u0018\u00010\u00152\b\u0010.\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lram/talia/hexal/api/casting/eval/env/WispCastEnv;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "level", "Lnet/minecraft/server/level/ServerLevel;", "(Lram/talia/hexal/common/entities/BaseCastingWisp;Lnet/minecraft/server/level/ServerLevel;)V", "getWisp", "()Lram/talia/hexal/common/entities/BaseCastingWisp;", "extractMediaEnvironment", "", "cost", "simulate", "", "getCastingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getCastingHand", "Lnet/minecraft/world/InteractionHand;", "getMishapEnvironment", "Lat/petrak/hexcasting/api/casting/eval/MishapEnvironment;", "getPigment", "Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "getPrimaryStacks", "", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment$HeldItemInfo;", "getUsableStacks", "Lnet/minecraft/world/item/ItemStack;", "mode", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment$StackDiscoveryMode;", "hasEditPermissionsAtEnvironment", "pos", "Lnet/minecraft/core/BlockPos;", "isVecInRangeEnvironment", "vec", "Lnet/minecraft/world/phys/Vec3;", "mishapSprayPos", "postExecution", "", "result", "Lat/petrak/hexcasting/api/casting/eval/CastResult;", "printMessage", "message", "Lnet/minecraft/network/chat/Component;", "produceParticles", "particles", "Lat/petrak/hexcasting/api/casting/ParticleSpray;", "pigment", "replaceItem", "stackOk", "Ljava/util/function/Predicate;", "replaceWith", "hand", "sendMishapMsgToPlayer", "mishap", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$DoMishap;", "setPigment", "hexal-forge-1.20.1"})
public final class WispCastEnv
extends CastingEnvironment {
    @NotNull
    private final BaseCastingWisp wisp;

    public WispCastEnv(@NotNull BaseCastingWisp wisp, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(level);
        this.wisp = wisp;
    }

    @NotNull
    public final BaseCastingWisp getWisp() {
        return this.wisp;
    }

    @Nullable
    public LivingEntity getCastingEntity() {
        return (LivingEntity)this.wisp.getCaster();
    }

    @NotNull
    public MishapEnvironment getMishapEnvironment() {
        ServerLevel serverLevel = this.world;
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"world");
        return new WispMishapEnv(this.wisp, serverLevel);
    }

    public void postExecution(@NotNull CastResult result) {
        ServerPlayer caster;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.postExecution(result);
        LivingEntity livingEntity = this.getCastingEntity();
        ServerPlayer serverPlayer = caster = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
        if (caster != null) {
            for (OperatorSideEffect sideEffect : result.getSideEffects()) {
                if (!(sideEffect instanceof OperatorSideEffect.DoMishap)) continue;
                this.sendMishapMsgToPlayer((OperatorSideEffect.DoMishap)sideEffect);
            }
        }
    }

    @NotNull
    public Vec3 mishapSprayPos() {
        Vec3 vec3 = this.wisp.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"wisp.position()");
        return vec3;
    }

    protected long extractMediaEnvironment(long cost, boolean simulate) {
        long mediaAvailable = this.wisp.getMedia();
        long mediaToTake = RangesKt.coerceAtMost((long)cost, (long)mediaAvailable);
        if (!simulate) {
            this.wisp.addMedia(-mediaToTake);
        }
        return cost - mediaToTake;
    }

    protected boolean isVecInRangeEnvironment(@NotNull Vec3 vec) {
        Sentinel sentinel;
        ServerPlayer caster;
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        LivingEntity livingEntity = this.getCastingEntity();
        ServerPlayer serverPlayer = caster = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
        if (caster != null && (sentinel = HexAPI.instance().getSentinel(caster)) != null && sentinel.extendsRange() && caster.m_9236_().m_46472_() == sentinel.dimension() && vec.m_82557_(sentinel.position()) <= 256.0) {
            return true;
        }
        return vec.m_82557_(this.wisp.m_20182_()) <= this.wisp.maxSqrCastingDistance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasEditPermissionsAtEnvironment(@NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        ServerPlayer serverPlayer = this.getCaster();
        if ((serverPlayer != null && (serverPlayer = serverPlayer.f_8941_) != null ? serverPlayer.m_9290_() : null) == GameType.ADVENTURE) return false;
        ServerPlayer serverPlayer2 = this.getCaster();
        if (serverPlayer2 == null) return true;
        ServerPlayer it = serverPlayer2;
        boolean bl = false;
        boolean bl2 = this.world.m_7966_((Player)it, pos2);
        if (!bl2) return false;
        return true;
    }

    @NotNull
    public InteractionHand getCastingHand() {
        return InteractionHand.MAIN_HAND;
    }

    @NotNull
    protected List<ItemStack> getUsableStacks(@NotNull CastingEnvironment.StackDiscoveryMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return new ArrayList();
    }

    @NotNull
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        return new ArrayList();
    }

    public boolean replaceItem(@NotNull Predicate<ItemStack> stackOk, @NotNull ItemStack replaceWith, @Nullable InteractionHand hand) {
        Intrinsics.checkNotNullParameter(stackOk, (String)"stackOk");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        return false;
    }

    @NotNull
    public FrozenPigment getPigment() {
        return this.wisp.pigment();
    }

    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        FrozenPigment frozenPigment;
        FrozenPigment frozenPigment2 = pigment;
        if (frozenPigment2 != null) {
            FrozenPigment it = frozenPigment2;
            boolean bl = false;
            frozenPigment = this.wisp.setPigment(it);
        } else {
            frozenPigment = null;
        }
        return frozenPigment;
    }

    public void produceParticles(@NotNull ParticleSpray particles, @NotNull FrozenPigment pigment) {
        Intrinsics.checkNotNullParameter((Object)particles, (String)"particles");
        Intrinsics.checkNotNullParameter((Object)pigment, (String)"pigment");
        ServerLevel serverLevel = this.world;
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"world");
        particles.sprayParticles(serverLevel, pigment);
    }

    public void printMessage(@NotNull Component message) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LivingEntity livingEntity = this.getCastingEntity();
            ServerPlayer serverPlayer = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
            if (serverPlayer == null) break block0;
            serverPlayer.m_213846_(message);
        }
    }

    private final void sendMishapMsgToPlayer(OperatorSideEffect.DoMishap mishap) {
        Component msg = mishap.getMishap().errorMessageWithName((CastingEnvironment)this, mishap.getErrorCtx());
        if (msg != null) {
            this.printMessage(msg);
        }
    }
}

