/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class ControllerRenderer
implements BlockEntityRenderer<StorageControllerTile> {
    public static RenderType TYPE = RenderType.m_173215_((String)"custom_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172757_)).m_110663_(new RenderStateShard.DepthTestStateShard("always", 519)).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(new RenderStateShard.LayeringStateShard("view_offset_z_layering", () -> {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85841_(0.99975586f, 0.99975586f, 0.99975586f);
        RenderSystem.applyModelViewMatrix();
    }, () -> {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    })).m_110661_(new RenderStateShard.CullStateShard(false)).m_110691_(false));
    private static RenderType AREA_TYPE = ControllerRenderer.createRenderType();

    private static void renderShape(PoseStack p_109783_, VertexConsumer p_109784_, VoxelShape p_109785_, double p_109786_, double p_109787_, double p_109788_, float p_109789_, float p_109790_, float p_109791_, float p_109792_) {
        PoseStack.Pose posestack$pose = p_109783_.m_85850_();
        p_109785_.m_83224_((p_194324_, p_194325_, p_194326_, p_194327_, p_194328_, p_194329_) -> {
            float f = (float)(p_194327_ - p_194324_);
            float f1 = (float)(p_194328_ - p_194325_);
            float f2 = (float)(p_194329_ - p_194326_);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            p_109784_.m_252986_(posestack$pose.m_252922_(), (float)(p_194324_ + p_109786_), (float)(p_194325_ + p_109787_), (float)(p_194326_ + p_109788_)).m_85950_(p_109789_, p_109790_, p_109791_, p_109792_).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            p_109784_.m_252986_(posestack$pose.m_252922_(), (float)(p_194327_ + p_109786_), (float)(p_194328_ + p_109787_), (float)(p_194329_ + p_109788_)).m_85950_(p_109789_, p_109790_, p_109791_, p_109792_).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
        });
    }

    public void render(StorageControllerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41720_() instanceof LinkingToolItem) {
            VoxelShape shape;
            CompoundTag controllerNBT = stack.m_41784_().m_128469_("Controller");
            BlockPos controller = new BlockPos(controllerNBT.m_128451_("X"), controllerNBT.m_128451_("Y"), controllerNBT.m_128451_("Z"));
            if (!controller.equals((Object)tile.m_58899_())) {
                return;
            }
            if (stack.m_41784_().m_128441_("First")) {
                CompoundTag firstpos = stack.m_41784_().m_128469_("First");
                BlockPos firstPos = new BlockPos(firstpos.m_128451_("X"), firstpos.m_128451_("Y"), firstpos.m_128451_("Z"));
                HitResult result = RayTraceUtils.rayTraceSimple((Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, (double)8.0, (float)partialTicks);
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos hit = ((BlockHitResult)result).m_82425_();
                    AABB aabb = new AABB((double)Math.min(firstPos.m_123341_(), hit.m_123341_()), (double)Math.min(firstPos.m_123342_(), hit.m_123342_()), (double)Math.min(firstPos.m_123343_(), hit.m_123343_()), (double)(Math.max(firstPos.m_123341_(), hit.m_123341_()) + 1), (double)(Math.max(firstPos.m_123342_(), hit.m_123342_()) + 1), (double)(Math.max(firstPos.m_123343_(), hit.m_123343_()) + 1));
                    VoxelShape shape2 = Shapes.m_83064_((AABB)aabb);
                    ControllerRenderer.renderShape(matrixStack, bufferIn.m_6299_(TYPE), shape2, -controller.m_123341_(), -controller.m_123342_(), -controller.m_123343_(), 1.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
            if ((shape = tile.getConnectedDrawers().getCachedVoxelShape()) == null || tile.m_58904_().m_46467_() % 400L == 0L) {
                tile.getConnectedDrawers().rebuildShapes();
                shape = tile.getConnectedDrawers().getCachedVoxelShape();
            }
            List list = shape.m_83299_();
            int i = Mth.m_14165_((double)((double)list.size() / 3.0));
            for (int j = 0; j < list.size(); ++j) {
                AABB aabb = (AABB)list.get(j);
                float f = ((float)j % (float)i + 1.0f) / (float)i;
                float f1 = j / i;
                float f2 = 1.0f;
                float f3 = 1.0f;
                float f4 = 1.0f;
                ControllerRenderer.renderShape(matrixStack, bufferIn.m_6299_(TYPE), Shapes.m_83064_((AABB)aabb.m_82386_(0.0, 0.0, 0.0)), -tile.m_58899_().m_123341_(), -tile.m_58899_().m_123342_(), -tile.m_58899_().m_123343_(), f2, f3, f4, 1.0f);
            }
            int extraRange = tile.getStorageMultiplier();
            if (extraRange == 1) {
                extraRange = 0;
            }
            AABB area = new AABB(tile.m_58899_()).m_82400_((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
            ControllerRenderer.renderShape(matrixStack, bufferIn.m_6299_(TYPE), Shapes.m_83064_((AABB)area), -tile.m_58899_().m_123341_(), -tile.m_58899_().m_123342_(), -tile.m_58899_().m_123343_(), 0.5f, 1.0f, 0.5f, 1.0f);
            this.renderFaces(matrixStack, bufferIn, area, -tile.m_58899_().m_123341_(), -tile.m_58899_().m_123342_(), -tile.m_58899_().m_123343_(), 0.5f, 1.0f, 0.5f, 0.25f);
        }
    }

    public boolean shouldRender(StorageControllerTile p_173568_, Vec3 p_173569_) {
        return true;
    }

    public boolean shouldRenderOffScreen(StorageControllerTile p_112306_) {
        return true;
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).m_110663_(new RenderStateShard.DepthTestStateShard("<=", 515)).m_110691_(true);
        return RenderType.m_173215_((String)"controller_area", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    private void renderFaces(PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.f_82288_ + x);
        float x2 = (float)(pos.f_82291_ + x);
        float y1 = (float)(pos.f_82289_ + y);
        float y2 = (float)(pos.f_82292_ + y);
        float z1 = (float)(pos.f_82290_ + z);
        float z2 = (float)(pos.f_82293_ + z);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        VertexConsumer buffer = renderTypeBuffer.m_6299_(AREA_TYPE);
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
    }
}

