/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

@NothingNullByDefault
public interface IItemStackIngredientCreator
extends IIngredientCreator<Item, ItemStack, ItemStackIngredient> {
    @Override
    default public ItemStackIngredient from(ItemStack instance) {
        Objects.requireNonNull(instance, "ItemStackIngredients cannot be created from a null ItemStack.");
        return this.from(instance, instance.m_41613_());
    }

    @Override
    default public ItemStackIngredient from(ItemStack stack, int amount) {
        Objects.requireNonNull(stack, "ItemStackIngredients cannot be created from a null ItemStack.");
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created using the empty stack.");
        }
        StrictNBTIngredient ingredient = (stack = stack.m_41777_()).m_41782_() ? StrictNBTIngredient.of((ItemStack)stack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        return this.from((Ingredient)ingredient, amount);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item) {
        return this.from(item, 1);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item, int amount) {
        return this.from(new ItemStack(item), amount);
    }

    @Override
    default public ItemStackIngredient from(Item item, int amount) {
        return this.from((ItemLike)item, amount);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag) {
        return this.from((TagKey)tag, 1);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag, int amount) {
        Objects.requireNonNull(tag, "ItemStackIngredients cannot be created from a null tag.");
        return this.from(Ingredient.m_204132_(tag), amount);
    }

    @Override
    default public ItemStackIngredient from(Ingredient ingredient) {
        return this.from(ingredient, 1);
    }

    @Override
    public ItemStackIngredient from(Ingredient var1, int var2);
}

