/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client.integration;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.satisfy.beachparty.core.registry.MobEffectRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CuriosWearableTrinket {
    private static final Random RANDOM = new Random();

    public static boolean isCurioEquipped(Player player, Item ... curios) {
        return CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> {
            for (Item curio : curios) {
                if (stack.m_41720_() != curio) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    public static class SwimWingsCurio
    extends BaseCurio {
        public SwimWingsCurio() {
            super((Item)ObjectRegistry.SWIM_WINGS.get());
        }

        @Override
        public void curioTick(SlotContext slotContext, ItemStack stack) {
            Player player;
            LivingEntity entity = slotContext.entity();
            if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_() && !player.m_20096_() && player.m_20184_().f_82480_ < (double)-0.1f && player.f_19789_ > 3.0f && !player.m_36335_().m_41519_((Item)ObjectRegistry.SWIM_WINGS.get())) {
                player.f_19789_ *= 0.5f;
                player.m_36335_().m_41524_((Item)ObjectRegistry.SWIM_WINGS.get(), 100);
            }
        }

        @Override
        protected void removeEffect(Player player) {
            player.m_36335_().m_41527_((Item)ObjectRegistry.SWIM_WINGS.get());
        }
    }

    public static class SwimSuitCurio
    extends BaseCurio {
        public SwimSuitCurio() {
            super((Item)ObjectRegistry.TRUNKS.get(), (Item)ObjectRegistry.BIKINI.get());
        }

        @Override
        public void curioTick(SlotContext slotContext, ItemStack stack) {
            Player player;
            LivingEntity entity = slotContext.entity();
            if (entity instanceof Player && (player = (Player)entity).m_20069_() && player.m_6069_()) {
                Vec3 newMotion = player.m_20184_().m_82542_(1.08, 1.0, 1.08);
                double maxSpeed = 0.3;
                if (newMotion.m_82556_() > maxSpeed * maxSpeed) {
                    newMotion = newMotion.m_82541_().m_82490_(maxSpeed);
                }
                player.m_20256_(new Vec3(newMotion.f_82479_, player.m_20184_().f_82480_, newMotion.f_82481_));
            }
        }
    }

    public static class RubberRingCurio
    extends BaseCurio {
        public RubberRingCurio() {
            super((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get(), (Item)ObjectRegistry.RUBBER_RING_PELICAN.get(), (Item)ObjectRegistry.RUBBER_RING_BLUE.get(), (Item)ObjectRegistry.RUBBER_RING_STRIPPED.get(), (Item)ObjectRegistry.RUBBER_RING_PINK.get());
        }

        @Override
        public void curioTick(SlotContext slotContext, ItemStack stack) {
            LivingEntity entity = slotContext.entity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (player.m_20069_()) {
                Vec3 motion = player.m_20184_();
                if (motion.f_82480_ > 0.08) {
                    return;
                }
                double targetUpwardSpeed = 0.3;
                double newY = motion.f_82480_;
                if (motion.f_82480_ < targetUpwardSpeed && (newY += 0.01) > targetUpwardSpeed) {
                    newY = targetUpwardSpeed;
                }
                double maxSpeed = 0.3;
                double newX = Math.min(motion.f_82479_ * 1.08, maxSpeed);
                double newZ = Math.min(motion.f_82481_ * 1.08, maxSpeed);
                player.m_20256_(new Vec3(newX, newY, newZ));
                BlockPos pos = player.m_20183_().m_7494_();
                for (int maxIterations = 10; player.m_9236_().m_8055_(pos).m_60819_().m_76178_() && maxIterations > 0; --maxIterations) {
                    pos = pos.m_7495_();
                }
                double targetY = pos.m_123342_();
                if (player.m_20186_() > targetY && !player.m_5842_()) {
                    player.m_6034_(player.m_20185_(), targetY, player.m_20189_());
                }
                Vec3 viewDir = player.m_20252_(1.0f);
                Vec3 sideOffset = new Vec3(-viewDir.f_82481_, 0.0, viewDir.f_82479_).m_82541_().m_82490_(0.45);
                Vec3 leftHandPos = player.m_20182_().m_82549_(sideOffset).m_82520_(0.0, (double)player.m_20192_() - 0.4, 0.0);
                Vec3 rightHandPos = player.m_20182_().m_82546_(sideOffset).m_82520_(0.0, (double)player.m_20192_() - 0.4, 0.0);
                this.spawnWaterParticles(player, leftHandPos, rightHandPos);
            }
        }

        private void spawnWaterParticles(Player player, Vec3 leftPos, Vec3 rightPos) {
            block4: {
                double spread;
                block3: {
                    if (!player.m_9236_().m_5776_()) {
                        return;
                    }
                    spread = 0.2;
                    double motionThreshold = 0.005;
                    if (!(player.m_20184_().m_82556_() > motionThreshold)) break block3;
                    for (int i = 0; i < 2; ++i) {
                        this.spawnParticlePair(player, (ParticleOptions)ParticleTypes.f_123769_, leftPos, rightPos, spread);
                        this.spawnParticlePair(player, (ParticleOptions)ParticleTypes.f_123772_, leftPos, rightPos, spread);
                    }
                    break block4;
                }
                if (player.m_9236_().m_46467_() % 20L != 0L) break block4;
                for (int i = 0; i < 4; ++i) {
                    this.spawnRandomSplash(player, spread);
                }
            }
        }

        private void spawnParticlePair(Player player, ParticleOptions particle, Vec3 leftPos, Vec3 rightPos, double spread) {
            this.spawnParticle(player, particle, leftPos, spread);
            this.spawnParticle(player, particle, rightPos, spread);
        }

        private void spawnParticle(Player player, ParticleOptions particle, Vec3 pos, double spread) {
            player.m_9236_().m_7106_(particle, pos.f_82479_ + (RANDOM.nextDouble() * spread - spread / 2.0), pos.f_82480_ + (RANDOM.nextDouble() * spread - spread / 2.0), pos.f_82481_ + (RANDOM.nextDouble() * spread - spread / 2.0), 0.0, 0.0, 0.0);
        }

        private void spawnRandomSplash(Player player, double spread) {
            double offset = 0.25;
            double angle = RANDOM.nextDouble() * Math.PI * 2.0;
            double xOffset = Math.cos(angle) * offset;
            double zOffset = Math.sin(angle) * offset;
            double x = player.m_20185_() + xOffset;
            double y = player.m_20186_() + (double)player.m_20192_() - 0.5 + (RANDOM.nextDouble() * spread - spread / 2.0);
            double z = player.m_20189_() + zOffset;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static class CrocsCurio
    extends BaseCurio {
        public CrocsCurio() {
            super((Item)ObjectRegistry.CROCS.get());
        }

        public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
            Player player;
            super.onEquip(slotContext, prevStack, stack);
            LivingEntity entity = slotContext.entity();
            if (entity instanceof Player && !(player = (Player)entity).m_21023_((MobEffect)MobEffectRegistry.OCEAN_WALK.get())) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.OCEAN_WALK.get(), -1, 0, false, false));
            }
        }

        @Override
        protected void removeEffect(Player player) {
            player.m_21195_((MobEffect)MobEffectRegistry.OCEAN_WALK.get());
        }
    }

    public static class BaseCurio
    implements ICurioItem {
        private final Item[] conflictingItems;

        public BaseCurio(Item ... conflictingItems) {
            this.conflictingItems = conflictingItems;
        }

        public void curioTick(SlotContext slotContext, ItemStack stack) {
        }

        public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
            LivingEntity entity = slotContext.entity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.removeEffect(player);
            }
        }

        protected void removeEffect(Player player) {
        }

        public boolean canEquip(SlotContext slotContext, ItemStack stack) {
            LivingEntity entity = slotContext.entity();
            if (!(entity instanceof Player)) {
                return false;
            }
            Player player = (Player)entity;
            return !CuriosWearableTrinket.isCurioEquipped(player, this.conflictingItems);
        }
    }
}

