/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.Item;
import net.satisfy.beachparty.client.model.BeachHatModel;
import net.satisfy.beachparty.client.model.BikiniModel;
import net.satisfy.beachparty.client.model.ChestplateModel;
import net.satisfy.beachparty.client.model.CrocsModel;
import net.satisfy.beachparty.client.model.HatModel;
import net.satisfy.beachparty.client.model.LeggingsModel;
import net.satisfy.beachparty.client.model.RubberRingAxolotlModel;
import net.satisfy.beachparty.client.model.RubberRingColoredModel;
import net.satisfy.beachparty.client.model.RubberRingPelicanModel;
import net.satisfy.beachparty.client.model.SunglassesModel;
import net.satisfy.beachparty.client.model.SwimWingsModel;
import net.satisfy.beachparty.client.model.TrunksModel;
import net.satisfy.beachparty.core.registry.ObjectRegistry;

public class ArmorRegistry {
    private static final Map<Item, HatModel> hatModel = new HashMap<Item, HatModel>();
    private static final Map<Item, ChestplateModel> chestplateModel = new HashMap<Item, ChestplateModel>();
    private static final Map<Item, LeggingsModel> leggingsModel = new HashMap<Item, LeggingsModel>();

    public static Model chestplateModel(Item item, ModelPart baseBody, ModelPart leftArm, ModelPart rightArm) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        ChestplateModel model = chestplateModel.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.RUBBER_RING_BLUE.get()) {
                return new RubberRingColoredModel(modelSet.m_171103_(RubberRingColoredModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.RUBBER_RING_PINK.get()) {
                return new RubberRingColoredModel(modelSet.m_171103_(RubberRingColoredModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.RUBBER_RING_STRIPPED.get()) {
                return new RubberRingColoredModel(modelSet.m_171103_(RubberRingColoredModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.RUBBER_RING_AXOLOTL.get()) {
                return new RubberRingAxolotlModel(modelSet.m_171103_(RubberRingAxolotlModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.RUBBER_RING_PELICAN.get()) {
                return new RubberRingPelicanModel(modelSet.m_171103_(RubberRingPelicanModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.BIKINI.get()) {
                return new BikiniModel(modelSet.m_171103_(BikiniModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.SWIM_WINGS.get()) {
                return new SwimWingsModel(modelSet.m_171103_(SwimWingsModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyBody(baseBody, leftArm, rightArm);
        return (Model)model;
    }

    public static Model HelmetModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        HatModel model = hatModel.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BEACH_HAT.get()) {
                return new BeachHatModel(modelSet.m_171103_(BeachHatModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.SUNGLASSES.get()) {
                return new SunglassesModel(modelSet.m_171103_(SunglassesModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyHead(baseHead);
        return (Model)model;
    }

    public static Model LeggingsModel(Item item, ModelPart baseBody, ModelPart leftLeg, ModelPart rightLeg) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        LeggingsModel model = leggingsModel.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.TRUNKS.get()) {
                return new TrunksModel(modelSet.m_171103_(TrunksModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.CROCS.get()) {
                return new CrocsModel(modelSet.m_171103_(CrocsModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyBody(baseBody, leftLeg, rightLeg);
        return (Model)model;
    }
}

