/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class PalmGlassBlock
extends Block {
    public static final EnumProperty<VerticalPart> PART = EnumProperty.m_61587_((String)"part", VerticalPart.class);

    public PalmGlassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)VerticalPart.NONE)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!level.m_5776_()) {
            this.updateVertical(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.m_5776_()) {
            this.updateVertical(level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_()) {
            BlockPos up = pos.m_7494_();
            BlockPos down = pos.m_7495_();
            if (level.m_8055_(up).m_60734_() == this) {
                this.updateVertical(level, up);
            }
            if (level.m_8055_(down).m_60734_() == this) {
                this.updateVertical(level, down);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART});
    }

    private void updateVertical(Level level, BlockPos pos) {
        BlockPos bottom = pos;
        while (level.m_8055_(bottom.m_7495_()).m_60734_() == this) {
            bottom = bottom.m_7495_();
        }
        BlockPos top = pos;
        while (level.m_8055_(top.m_7494_()).m_60734_() == this) {
            top = top.m_7494_();
        }
        ArrayList<Vector3i> positions = new ArrayList<Vector3i>();
        Vector3i current = new Vector3i(bottom.m_123341_(), bottom.m_123342_(), bottom.m_123343_());
        Vector3i end = new Vector3i(top.m_123341_(), top.m_123342_(), top.m_123343_());
        positions.add(new Vector3i(current.x, current.y, current.z));
        while (!current.equals((Object)end)) {
            current = new Vector3i(current.x, current.y + 1, current.z);
            positions.add(new Vector3i(current.x, current.y, current.z));
        }
        if (positions.size() == 1) {
            Vector3i v = (Vector3i)positions.get(0);
            BlockPos bp = new BlockPos(v.x, v.y, v.z);
            level.m_7731_(bp, (BlockState)level.m_8055_(bp).m_61124_(PART, (Comparable)((Object)VerticalPart.NONE)), 3);
        } else {
            for (int i = 0; i < positions.size(); ++i) {
                Vector3i v = (Vector3i)positions.get(i);
                BlockPos bp = new BlockPos(v.x, v.y, v.z);
                BlockState s = level.m_8055_(bp);
                s = i == 0 ? (BlockState)s.m_61124_(PART, (Comparable)((Object)VerticalPart.BOTTOM)) : (i == positions.size() - 1 ? (BlockState)s.m_61124_(PART, (Comparable)((Object)VerticalPart.TOP)) : (BlockState)s.m_61124_(PART, (Comparable)((Object)VerticalPart.MIDDLE)));
                level.m_7731_(bp, s, 3);
            }
        }
    }

    public static enum VerticalPart implements StringRepresentable
    {
        NONE("none"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private VerticalPart(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

