/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineConnectingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BeachpartyUtil.LineConnectingType> TYPE = BeachpartyUtil.LINE_CONNECTING_TYPE;

    public LineConnectingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState arg, Level arg2, BlockPos arg3, Player arg4, InteractionHand arg5, BlockHitResult arg6) {
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122019_()), world.m_8055_(clickedPos.m_122012_()))));
            case Direction.SOUTH -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122024_()), world.m_8055_(clickedPos.m_122029_()))));
            case Direction.WEST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122012_()), world.m_8055_(clickedPos.m_122019_()))));
            default -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122029_()), world.m_8055_(clickedPos.m_122024_()))));
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BeachpartyUtil.LineConnectingType type = switch (facing) {
            case Direction.EAST -> this.getType(state, world.m_8055_(pos.m_122019_()), world.m_8055_(pos.m_122012_()));
            case Direction.SOUTH -> this.getType(state, world.m_8055_(pos.m_122024_()), world.m_8055_(pos.m_122029_()));
            case Direction.WEST -> this.getType(state, world.m_8055_(pos.m_122012_()), world.m_8055_(pos.m_122019_()));
            default -> this.getType(state, world.m_8055_(pos.m_122029_()), world.m_8055_(pos.m_122024_()));
        };
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    public BeachpartyUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        if (left.m_60734_() == Blocks.f_50016_ || right.m_60734_() == Blocks.f_50016_) {
            return BeachpartyUtil.LineConnectingType.NONE;
        }
        boolean shape_left_same = this.isConnectable(left, state);
        boolean shape_right_same = this.isConnectable(right, state);
        if (shape_left_same && shape_right_same) {
            return BeachpartyUtil.LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return BeachpartyUtil.LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return BeachpartyUtil.LineConnectingType.RIGHT;
        }
        return BeachpartyUtil.LineConnectingType.NONE;
    }

    protected boolean isConnectable(BlockState state1, BlockState state2) {
        return state1.m_60734_() == state2.m_60734_() && state1.m_61143_((Property)FACING) == state2.m_61143_((Property)FACING);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

