/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CocktailBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);
    public static final VoxelShape SWEETBERRIES_COCKTAIL_SHAPE = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.3125, (double)0.625), (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875));
    public static final VoxelShape MELON_COCKTAIL_SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), Shapes.m_83048_((double)0.3125, (double)0.375, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875)});
    public static final VoxelShape COCONUT_COCKTAIL_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75);
    public static final VoxelShape PUMPKIN_COCKTAIL_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.625, (double)0.75);
    public static final VoxelShape HONEY_COCKTAIL_SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.25, (double)0.5625), Shapes.m_83048_((double)0.3125, (double)0.25, (double)0.3125, (double)0.6875, (double)0.8125, (double)0.6875)});
    public static final VoxelShape COCOA_COCKTAIL_SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), Shapes.m_83048_((double)0.3125, (double)0.375, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875)});
    private final MobEffect effect;
    private final int effectDuration;
    private final Supplier<VoxelShape> shapeSupplier;

    public CocktailBlock(BlockBehaviour.Properties settings, MobEffect effect, int effectDuration, Supplier<VoxelShape> shapeSupplier) {
        super(settings);
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.shapeSupplier = shapeSupplier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(3)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STAGE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapeSupplier.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            int stage = (Integer)state.m_61143_((Property)STAGE);
            if (stage > 1) {
                player.m_7292_(new MobEffectInstance(this.effect, this.effectDuration, 0));
                world.m_5594_(null, pos, SoundEvents.f_11911_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage - 1)), 3);
            } else if (stage == 1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                world.m_46961_(pos, false);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

