/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectorBlockEntity
extends SmartBlockEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation,
IDebugDrawer {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes;
    private final IWireNode[] nodeCache;
    private EnergyNetwork network;
    private int demand = 0;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    protected LazyOptional<IEnergyStorage> capability = this.createEmptyHandler();
    protected LazyOptional<IEnergyStorage> external = LazyOptional.empty();
    boolean externalStorageInvalid = false;
    private static final IEnergyStorage NULL_ES = new EnergyStorage(0, 0, 0);

    public AbstractConnectorBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
        this.localNodes = new LocalNode[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    private LazyOptional<IEnergyStorage> createEmptyHandler() {
        return LazyOptional.of(() -> new InterfaceEnergyHandler());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract int getMaxIn();

    public abstract int getMaxOut();

    public int getCapacity() {
        return Math.min(this.getMaxIn(), this.getMaxOut());
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.f_58857_);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    public boolean isEnergyInput(Direction side) {
        return this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING) == side;
    }

    public boolean isEnergyOutput(Direction side) {
        return this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING) == side;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.m_128441_("node0")) {
            this.convertOldNbt(nbt);
            this.m_6596_();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = nbt.m_128437_("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)tag);
        });
        if (nbt.m_128441_("contraption") && !clientPacket) {
            this.wasContraption = nbt.m_128471_("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.m_58900_().m_61143_(NodeRotation.ROTATION));
            if (this.f_58857_ == null) {
                return;
            }
            if (rotation != NodeRotation.NONE) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.network != null) {
            this.network.invalidate();
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag tag = new CompoundTag();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.m_128365_("nodes", (Tag)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.network != null) {
                this.network.invalidate();
            }
        }
    }

    public void firstTick() {
        this.firstTick = false;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.wasContraption && !this.f_58857_.m_5776_()) {
            this.wasContraption = false;
            this.validateNodes();
        }
        this.updateExternalEnergyStorage();
    }

    protected void specialTick() {
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick();
        }
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_46749_(this.m_58899_())) {
            return;
        }
        if (!this.wireCache.isEmpty() && !this.m_58901_()) {
            this.handleWireCache(this.f_58857_, this.wireCache);
        }
        this.specialTick();
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.awakeNetwork(this.f_58857_)) {
            this.notifyUpdate();
        }
        this.networkTick(this.network);
        if (this.externalStorageInvalid) {
            this.updateExternalEnergyStorage();
        }
    }

    private void networkTick(EnergyNetwork network) {
        ConnectorMode mode = this.getMode();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (mode == ConnectorMode.Push) {
            int pulled = network.pull(network.demand(((IEnergyStorage)this.external.orElse((Object)NULL_ES)).receiveEnergy(this.getMaxOut(), true)));
            ((IEnergyStorage)this.external.orElse((Object)NULL_ES)).receiveEnergy(pulled, false);
        }
        if (mode == ConnectorMode.Pull) {
            int toPush = ((IEnergyStorage)this.external.orElse((Object)NULL_ES)).extractEnergy(network.push(this.getMaxIn(), true), false);
            network.push(toPush);
        }
    }

    public void remove() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.m_58900_().m_61143_(AbstractConnectorBlock.MODE));
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        String spacing = " ";
        tooltip.add((Component)Component.m_237113_((String)spacing).m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.connector.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)spacing).m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.mode").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)spacing).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)((ConnectorMode)((Object)this.m_58900_().m_61143_(AbstractConnectorBlock.MODE))).getTooltip().m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237113_((String)spacing).m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)spacing).m_130946_(" ").m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.m_58900_().m_61143_(AbstractConnectorBlock.MODE))).isActive();
    }

    public void updateExternalEnergyStorage() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_46749_(this.m_58899_())) {
            return;
        }
        this.externalStorageInvalid = false;
        Direction side = (Direction)this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING);
        if (!this.f_58857_.m_46749_(this.f_58858_.m_121945_(side))) {
            this.external = LazyOptional.empty();
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (te == null) {
            this.external = LazyOptional.empty();
            return;
        }
        LazyOptional le = te.getCapability(ForgeCapabilities.ENERGY, side.m_122424_());
        if (this.ignoreCapSide() && !le.isPresent()) {
            le = te.getCapability(ForgeCapabilities.ENERGY);
        }
        if (le.equals(this.external)) {
            return;
        }
        this.external = le;
        le.addListener(es -> {
            this.externalStorageInvalid = true;
        });
    }

    @Override
    public void drawDebug() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            BlockPos pos = localNode.getPos();
            BlockState state = this.f_58857_.m_8055_(pos);
            VoxelShape shape = state.m_60816_((BlockGetter)this.f_58857_, pos);
            int color = i == 0 ? 0xFF0000 : (i == 1 ? 65280 : (i == 2 ? 255 : 0xFFFFFF));
            if (!(this.f_58857_.m_7702_(pos) instanceof IWireNode)) {
                shape = Shapes.m_83144_();
                color = 0xFF00FF;
            }
            Outliner.getInstance().chaseAABB((Object)("ca_nodes_" + i), shape.m_83215_().m_82338_(pos)).lineWidth(0.0625f).colored(color);
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING)));
        if (te == null) {
            return;
        }
        LazyOptional cap = te.getCapability(ForgeCapabilities.ENERGY, ((Direction)this.m_58900_().m_61143_((Property)AbstractConnectorBlock.FACING)).m_122424_());
        if (this.ignoreCapSide() && !cap.isPresent()) {
            cap = te.getCapability(ForgeCapabilities.ENERGY);
        }
        if (!cap.isPresent()) {
            return;
        }
        VoxelShape shape = this.f_58857_.m_8055_(te.m_58899_()).m_60816_((BlockGetter)this.f_58857_, te.m_58899_());
        Outliner.getInstance().chaseAABB((Object)"ca_output", shape.m_83215_().m_82338_(te.m_58899_())).lineWidth(0.0625f).colored(0x5B5BFF);
    }

    private class InterfaceEnergyHandler
    implements IEnergyStorage {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!((Boolean)Config.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Pull) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            maxReceive = Math.min(maxReceive, AbstractConnectorBlockEntity.this.getMaxIn());
            return AbstractConnectorBlockEntity.this.network.push(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!((Boolean)Config.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Push) {
                return 0;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            maxExtract = Math.min(maxExtract, AbstractConnectorBlockEntity.this.getMaxOut());
            return AbstractConnectorBlockEntity.this.network.pull(maxExtract, simulate);
        }

        public int getEnergyStored() {
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0;
            }
            return Math.min(AbstractConnectorBlockEntity.this.getCapacity(), AbstractConnectorBlockEntity.this.network.getBuff());
        }

        public int getMaxEnergyStored() {
            return AbstractConnectorBlockEntity.this.getCapacity();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

