/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.matching;

import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.impl.MatchContextImpl;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public interface MatchContext {
    public static MatchContext forInput(String inputText) {
        return new MatchContextImpl(inputText);
    }

    public static MatchContext forTextInput(Component inputText) {
        return new MatchContextImpl(inputText);
    }

    public boolean isFrozen();

    public void freeze();

    public String getOriginalText();

    public String getMatchableText(char var1);

    public boolean addMatch(int var1, int var2, InlineMatch var3);

    public Map<Integer, String> getUnmatchedSequences();

    public String getFinalText();

    public Component getFinalStyledText();

    public Map<Integer, InlineMatch> getFinalMatches();

    public Map<Integer, InlineMatch> getMatches();

    public int origToFinal(int var1);

    public int finalToOrig(int var1);

    public static interface ChatMatchContext
    extends MatchContext {
        public ServerPlayer getChatSender();

        public static ChatMatchContext of(ServerPlayer player, Component originalMessage) {
            return new MatchContextImpl.ChatMatchContextImpl(player, originalMessage);
        }
    }
}

