/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CauldronCraftingContainer
implements CraftingContainer {
    private final List<ItemStack> originalItems;
    private final NonNullList<ItemStack> items;
    private final SoftFluidStack fluid;
    private final int fluidContainerSize;
    private final Multimap<FluidContainerList.Category, ItemStack> equivalentFluidContainers;
    private final int dimension;
    private final int fluidPosition;
    private final boolean isBoiling;
    private static final FluidContainerList.Category DUMMY_WATER_BOWL_CATEGORY = (FluidContainerList.Category)Util.m_137537_(() -> {
        JsonElement j = JsonParser.parseString((String)("{\n    \"capacity\":" + SoftFluid.BOWL_COUNT + ",        \"empty\": \"minecraft:bowl\",\n        \"filled\": [\n        \"minecraft:mushroom_stew\"\n        ]\n    }\n"));
        return (FluidContainerList.Category)((Pair)FluidContainerList.Category.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow(false, s -> {})).getFirst();
    });

    private CauldronCraftingContainer(int fluidContainerSize, SoftFluidStack fluidStack, Collection<ItemStack> items, int fluidPosition, boolean isBoiling) {
        this.dimension = Mth.m_14165_((double)Math.sqrt(items.size() + 1));
        this.originalItems = List.copyOf(items);
        this.items = NonNullList.m_122780_((int)(this.dimension * this.dimension), (Object)ItemStack.f_41583_);
        this.fluid = fluidStack;
        this.equivalentFluidContainers = fluidStack.toAllPossibleFilledItems();
        if (fluidStack.is((Holder)BuiltInSoftFluids.WATER)) {
            this.equivalentFluidContainers.put((Object)DUMMY_WATER_BOWL_CATEGORY, (Object)Items.f_42399_.m_7968_());
        }
        this.fluidPosition = fluidPosition;
        Preconditions.checkArgument((fluidPosition <= items.size() ? 1 : 0) != 0);
        this.fluidContainerSize = fluidContainerSize;
        this.isBoiling = isBoiling;
    }

    public static CauldronCraftingContainer surround8(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, ItemStack item) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(item, item, item, item, item, item, item, item), 4, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, ItemStack ... items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(items), items.length, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, Collection<ItemStack> items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, items, items.size(), boiling);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        if (slot >= this.m_6643_()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    public int m_39347_() {
        return this.dimension;
    }

    public int m_39346_() {
        return this.dimension;
    }

    public List<ItemStack> m_280657_() {
        return this.items;
    }

    public SoftFluidStack getFluid() {
        return this.fluid;
    }

    public int getMaxAllowedFluidCount() {
        return this.fluidContainerSize;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
    }

    public void m_5809_(StackedContents helper) {
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCauldronRecipes(Level level) {
        for (int j = 0; j < this.originalItems.size(); ++j) {
            this.items.set(j, (Object)this.originalItems.get(j));
        }
        List recipes = level.m_7465_().m_44056_(ModRegistry.CAULDRON_RECIPE_TYPE.get(), (Container)this, level);
        for (CauldronRecipe r : recipes) {
            if (!r.matches(this, level)) continue;
            FluidAndItemCraftResult resultFluid = r.assembleFluid(this, level.m_9598_());
            NonNullList remainingItems = r.m_7457_((Container)this);
            if (!remainingItems.stream().allMatch(ItemStack::m_41619_)) continue;
            return resultFluid;
        }
        return null;
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCraftingRecipes(Level level) {
        for (Map.Entry cont : this.equivalentFluidContainers.entries()) {
            FluidContainerList.Category category = (FluidContainerList.Category)cont.getKey();
            ItemStack fluidInBottle = (ItemStack)cont.getValue();
            this.setupFluidItem(fluidInBottle);
            List recipes = level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)this, level);
            for (CraftingRecipe r : recipes) {
                ItemStack craftedItem;
                int newFluidCount;
                if (!r.m_5818_((Container)this, level) || (newFluidCount = this.fluid.getCount() - category.getCapacity()) < 0 || newFluidCount > this.fluidContainerSize || (craftedItem = r.m_5874_((Container)this, level.m_9598_())).m_41619_()) continue;
                NonNullList remainingItems = r.m_7457_((Container)this);
                Item emptyContainer = category.getEmptyContainer();
                if (remainingItems.stream().allMatch(ItemStack::m_41619_)) {
                    FluidContainerList.Category catt;
                    if (fluidInBottle.m_150930_(Items.f_42739_)) {
                        return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
                    }
                    Pair equivalentFluid = SoftFluidStack.fromItem((ItemStack)craftedItem);
                    if (equivalentFluid == null || (catt = (FluidContainerList.Category)equivalentFluid.getSecond()).getEmptyContainer() != emptyContainer) continue;
                    SoftFluidStack f = (SoftFluidStack)equivalentFluid.getFirst();
                    return FluidAndItemCraftResult.of(ItemStack.f_41583_, f.copyWithCount(this.fluid.getCount()));
                }
                if (!remainingItems.stream().allMatch(i -> i.m_41619_() || i.m_41720_() == emptyContainer)) continue;
                return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
            }
        }
        return null;
    }

    private void setupFluidItem(ItemStack filledFluidBottle) {
        this.items.clear();
        int j = 0;
        for (ItemStack item : this.originalItems) {
            if (j == this.fluidPosition) {
                ++j;
            }
            this.items.set(j, (Object)item);
            ++j;
        }
        this.items.set(this.fluidPosition, (Object)filledFluidBottle);
    }

    public boolean isBoiling() {
        return this.isBoiling;
    }
}

