/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.util.Locale;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.TextColor;

public final class FormatUtil
extends Enum<FormatUtil> {
    private static final String[] SIZE_UNITS;
    private static final /* synthetic */ FormatUtil[] $VALUES;

    public static FormatUtil[] values() {
        return (FormatUtil[])$VALUES.clone();
    }

    public static FormatUtil valueOf(String name) {
        return Enum.valueOf(FormatUtil.class, name);
    }

    public static String percent(double value, double max) {
        double percent = value * 100.0 / max;
        return (int)percent + "%";
    }

    public static String formatBytes(long bytes) {
        if (bytes <= 0L) {
            return "0 bytes";
        }
        int sizeIndex = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format(Locale.ENGLISH, "%.1f", (double)bytes / Math.pow(1024.0, sizeIndex)) + " " + SIZE_UNITS[sizeIndex];
    }

    public static Component formatBytes(long bytes, TextColor color, String suffix) {
        String unit;
        String value;
        if (bytes <= 0L) {
            value = "0";
            unit = "KB" + suffix;
        } else {
            int sizeIndex = (int)(Math.log(bytes) / Math.log(1024.0));
            value = String.format(Locale.ENGLISH, "%.1f", (double)bytes / Math.pow(1024.0, sizeIndex));
            unit = SIZE_UNITS[sizeIndex] + suffix;
        }
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(value, color))).append((Component)Component.space())).append((Component)Component.text(unit))).build();
    }

    public static String formatSeconds(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long second = seconds;
        long minute = second / 60L;
        second %= 60L;
        StringBuilder sb = new StringBuilder();
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (second != 0L) {
            sb.append(second).append("s ");
        }
        return sb.toString().trim();
    }

    private static /* synthetic */ FormatUtil[] $values() {
        return new FormatUtil[0];
    }

    static {
        $VALUES = FormatUtil.$values();
        SIZE_UNITS = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    }
}

