/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.structures.jisaw.condition;

import com.github.L_Ender.cataclysm.structures.jisaw.condition.AlwaysTrueCondition;
import com.github.L_Ender.cataclysm.structures.jisaw.condition.StructureCondition;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public interface StructureConditionType<C extends StructureCondition> {
    public static final Map<ResourceLocation, StructureConditionType<?>> CONDITION_TYPES_BY_NAME = new HashMap();
    public static final Map<StructureConditionType<?>, ResourceLocation> NAME_BY_CONDITION_TYPES = new HashMap();
    public static final Codec<StructureConditionType<?>> CONDITION_TYPE_CODEC = ResourceLocation.f_135803_.flatXmap(resourceLocation -> Optional.ofNullable(CONDITION_TYPES_BY_NAME.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown condition type: " + String.valueOf(resourceLocation))), conditionType -> Optional.of(NAME_BY_CONDITION_TYPES.get(conditionType)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No ID found for condition type " + String.valueOf(conditionType) + ". Is it registered?")));
    public static final Codec<StructureCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch("type", StructureCondition::type, StructureConditionType::codec);
    public static final StructureConditionType<AlwaysTrueCondition> ALWAYS_TRUE = StructureConditionType.register("always_true", AlwaysTrueCondition.CODEC);

    public static <C extends StructureCondition> StructureConditionType<C> register(ResourceLocation resourceLocation, Codec<C> codec) {
        StructureConditionType<C> conditionType = () -> codec;
        CONDITION_TYPES_BY_NAME.put(resourceLocation, conditionType);
        NAME_BY_CONDITION_TYPES.put(conditionType, resourceLocation);
        return conditionType;
    }

    private static <C extends StructureCondition> StructureConditionType<C> register(String id, Codec<C> codec) {
        return StructureConditionType.register(new ResourceLocation("cataclysm", id), codec);
    }

    public Codec<C> codec();
}

