/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.message;

import com.github.L_Ender.cataclysm.config.CMConfig;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageEntityCamera {
    private final int entityID;
    private final boolean firstperson;

    public MessageEntityCamera(int id, boolean firstperson) {
        this.entityID = id;
        this.firstperson = firstperson;
    }

    public MessageEntityCamera(Entity entity, boolean firstperson) {
        this(entity.m_19879_(), firstperson);
    }

    public MessageEntityCamera(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.firstperson = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.firstperson);
    }

    public static class Handler {
        public static boolean onMessage(MessageEntityCamera message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (message.firstperson) {
                        if (CMConfig.setFirstPerson && player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().m_91288_() == Minecraft.m_91087_().f_91074_) {
                            Minecraft.m_91087_().m_91118_(entity);
                            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
                        }
                    } else if (CMConfig.setThirdPerson && player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().m_91288_() == Minecraft.m_91087_().f_91074_) {
                        Minecraft.m_91087_().m_91118_(entity);
                        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

