/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Cursed_Sandstorm_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class Wrath_of_the_desert
extends Item {
    public Wrath_of_the_desert(Item.Properties group) {
        super(group);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)Cataclysm.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        boolean using = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().equals(stack);
        int useTime = Wrath_of_the_desert.getUseTime(stack);
        if (level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("PrevUseTime") != tag.m_128451_("UseTime")) {
                tag.m_128405_("PrevUseTime", Wrath_of_the_desert.getUseTime(stack));
            }
            int maxLoadTime = Wrath_of_the_desert.getMaxLoadTime();
            if (using && useTime < maxLoadTime) {
                int set = useTime + 1;
                Wrath_of_the_desert.setUseTime(stack, set);
            }
        }
        if (!using && (float)useTime > 0.0f) {
            Wrath_of_the_desert.setUseTime(stack, Math.max(0, useTime - 5));
        }
    }

    private static int getMaxLoadTime() {
        return 20;
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevUseTime", Wrath_of_the_desert.getUseTime(stack));
        tag.m_128405_("UseTime", useTime);
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public static float getPullingAmount(ItemStack itemStack, float partialTicks) {
        return Math.min(Wrath_of_the_desert.getLerpedUseTime(itemStack, partialTicks) / (float)Wrath_of_the_desert.getMaxLoadTime(), 1.0f);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / (float)Wrath_of_the_desert.getMaxLoadTime();
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private Entity getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 40.0;
        Vec3 srcVec = living.m_146892_();
        Vec3 lookVec = living.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        float var9 = 2.0f;
        List possibleList = level.m_45933_((Entity)living, living.m_20191_().m_82363_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range).m_82377_((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            AABB collisionBB = possibleEntity.m_20191_().m_82377_(1.0, 1.0, 1.0);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeleft) {
        if (living instanceof Player) {
            Player player = (Player)living;
            Entity pointedEntity = this.getPlayerLookTarget(level, living);
            int i = this.m_8105_(stack) - timeleft;
            float f = Wrath_of_the_desert.getPowerForTime(i);
            if (!((double)f < 0.1) && !level.f_46443_) {
                float baseYaw = player.m_146908_();
                float pitch = player.m_146909_();
                for (int j = -1; j <= 1; ++j) {
                    Cursed_Sandstorm_Entity largefireball;
                    LivingEntity target;
                    float yaw = baseYaw + (float)(j * 15);
                    float directionX = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    float directionY = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                    float directionZ = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                    double theta = (double)yaw * (Math.PI / 180);
                    double vecX = Math.cos(theta += 1.5707963267948966);
                    double vecZ = Math.sin(theta);
                    double x = player.m_20185_() + vecX;
                    double Z = player.m_20189_() + vecZ;
                    int p = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                    if (pointedEntity instanceof LivingEntity && !(target = (LivingEntity)pointedEntity).m_7307_((Entity)living)) {
                        largefireball = new Cursed_Sandstorm_Entity((LivingEntity)player, directionX, directionY, directionZ, player.m_9236_(), (float)CMConfig.CursedSandstormDamage * f + (float)CMConfig.CursedSandstormDamage * f * (float)p * 0.05f, target);
                        largefireball.m_6034_(x, player.m_20188_() - 0.5, Z);
                        largefireball.setUp(15);
                        level.m_7967_((Entity)largefireball);
                        continue;
                    }
                    largefireball = new Cursed_Sandstorm_Entity((LivingEntity)player, directionX, directionY, directionZ, player.m_9236_(), (float)CMConfig.CursedSandstormDamage * f + (float)CMConfig.CursedSandstormDamage * f * (float)p * 0.05f, null);
                    largefireball.m_6034_(x, player.m_20188_() - 0.5, Z);
                    largefireball.setUp(15);
                    level.m_7967_((Entity)largefireball);
                }
                level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 16;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.BOW && enchantment != Enchantments.f_44952_ && enchantment != Enchantments.f_44990_ && enchantment != Enchantments.f_44989_;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ModItems.WRATH_OF_THE_DESERT.get()) || !newStack.m_150930_((Item)ModItems.WRATH_OF_THE_DESERT.get());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.wrath_of_the_desert.desc").m_130940_(ChatFormatting.DARK_GREEN));
    }
}

